/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.avro;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import io.trino.filesystem.TrinoInputFile;
import io.trino.hive.formats.TrinoDataInputStream;
import io.trino.hive.formats.avro.AvroPageDataReader;
import io.trino.hive.formats.avro.AvroTypeException;
import io.trino.hive.formats.avro.AvroTypeManager;
import io.trino.spi.Page;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.io.DatumReader;

public class AvroFileReader
implements Closeable {
    private final TrinoDataInputStream input;
    private final AvroPageDataReader dataReader;
    private final DataFileReader<Optional<Page>> fileReader;
    private Page nextPage;
    private final OptionalLong end;

    public AvroFileReader(TrinoInputFile inputFile, Schema schema, AvroTypeManager avroTypeManager) throws IOException, AvroTypeException {
        this(inputFile, schema, avroTypeManager, 0L, OptionalLong.empty());
    }

    public AvroFileReader(TrinoInputFile inputFile, Schema schema, AvroTypeManager avroTypeManager, long offset, OptionalLong length) throws IOException, AvroTypeException {
        Objects.requireNonNull(inputFile, "inputFile is null");
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(avroTypeManager, "avroTypeManager is null");
        long fileSize = inputFile.length();
        Verify.verify((offset >= 0L ? 1 : 0) != 0, (String)"offset is negative", (Object[])new Object[0]);
        Verify.verify((offset < inputFile.length() ? 1 : 0) != 0, (String)"offset is greater than data size", (Object[])new Object[0]);
        length.ifPresent(lengthLong -> Verify.verify((lengthLong >= 1L ? 1 : 0) != 0, (String)"length must be at least 1", (Object[])new Object[0]));
        this.end = length.stream().map(l -> l + offset).findFirst();
        this.end.ifPresent(endLong -> Verify.verify((endLong <= fileSize ? 1 : 0) != 0, (String)"offset plus length is greater than data size", (Object[])new Object[0]));
        this.input = new TrinoDataInputStream(inputFile.newStream());
        this.dataReader = new AvroPageDataReader(schema, avroTypeManager);
        try {
            this.fileReader = new DataFileReader((SeekableInput)new TrinoDataInputStreamAsAvroSeekableInput(this.input, fileSize), (DatumReader)this.dataReader);
            this.fileReader.sync(offset);
        }
        catch (AvroPageDataReader.UncheckedAvroTypeException runtimeWrapper) {
            throw runtimeWrapper.getAvroTypeException();
        }
        avroTypeManager.configure((Map)this.fileReader.getMetaKeys().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), arg_0 -> this.fileReader.getMeta(arg_0))));
    }

    public long getCompletedBytes() {
        return this.input.getReadBytes();
    }

    public long getReadTimeNanos() {
        return this.input.getReadTimeNanos();
    }

    public boolean hasNext() throws IOException {
        this.loadNextPageIfNecessary();
        return this.nextPage != null;
    }

    public Page next() throws IOException {
        if (!this.hasNext()) {
            throw new IOException("No more pages available from Avro file");
        }
        Page result = this.nextPage;
        this.nextPage = null;
        return result;
    }

    private void loadNextPageIfNecessary() throws IOException {
        while (this.nextPage == null && (this.end.isEmpty() || !this.fileReader.pastSync(this.end.getAsLong())) && this.fileReader.hasNext()) {
            try {
                this.nextPage = ((Optional)this.fileReader.next()).orElse(null);
            }
            catch (AvroRuntimeException e) {
                throw new IOException(e);
            }
        }
        if (this.nextPage == null) {
            this.nextPage = this.dataReader.flush().orElse(null);
        }
    }

    @Override
    public void close() throws IOException {
        this.fileReader.close();
    }

    private record TrinoDataInputStreamAsAvroSeekableInput(TrinoDataInputStream inputStream, long fileSize) implements SeekableInput
    {
        TrinoDataInputStreamAsAvroSeekableInput {
            Objects.requireNonNull(inputStream, "inputStream is null");
        }

        public void seek(long p) throws IOException {
            this.inputStream.seek(p);
        }

        public long tell() throws IOException {
            return this.inputStream.getPos();
        }

        public long length() {
            return this.fileSize;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.inputStream.read(b, off, len);
        }

        public void close() throws IOException {
            this.inputStream.close();
        }
    }
}

