/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line.text;

import com.google.common.io.CountingOutputStream;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.trino.hive.formats.compression.CompressionKind;
import io.trino.hive.formats.line.LineWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import java.util.function.LongSupplier;

public class TextLineWriter
implements LineWriter {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(TextLineWriter.class);
    private final LongSupplier writtenBytes;
    private final OutputStream outputStream;

    public TextLineWriter(OutputStream outputStream, Optional<CompressionKind> compressionKind) throws IOException {
        CountingOutputStream countingOutputStream = new CountingOutputStream(outputStream);
        this.writtenBytes = () -> ((CountingOutputStream)countingOutputStream).getCount();
        this.outputStream = compressionKind.isPresent() ? compressionKind.get().createCodec().createStreamCompressor((OutputStream)countingOutputStream) : outputStream;
    }

    @Override
    public long getWrittenBytes() {
        return this.writtenBytes.getAsLong();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }

    @Override
    public void write(Slice value) throws IOException {
        value.getBytes(0, this.outputStream, value.length());
        this.outputStream.write(10);
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

