/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.encodings.text;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.hive.formats.HiveFormatUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TextEncodingOptions {
    private static final String FORMAT_KEY = "serialization.format";
    private static final String NULL_FORMAT_KEY = "serialization.null.format";
    private static final String LAST_COLUMN_TAKES_REST_KEY = "serialization.last.column.takes.rest";
    private static final String FIELD_DELIMITER_KEY = "field.delim";
    private static final String COLLECTION_DELIMITER_KEY = "collection.delim";
    private static final String MAP_KEY_DELIMITER_KEY = "mapkey.delim";
    private static final String ESCAPE_CHAR_KEY = "escape.delim";
    private static final Slice DEFAULT_NULL_SEQUENCE = Slices.utf8Slice((String)"\\N");
    private static final byte[] DEFAULT_SEPARATORS = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 11, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 28, 29, 30, 31, -128, -127, -126, -125, -124, -123, -122, -121, -120, -119, -118, -117, -116, -115, -114, -113, -112, -111, -110, -109, -108, -107, -106, -105, -104, -103, -102, -101, -100, -99, -98, -97, -96, -95, -94, -93, -92, -91, -90, -89, -88, -87, -86, -85, -84, -83, -82, -81, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -69, -68, -67, -66, -65, -64, -63, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, -52, -51, -50, -49, -48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1};
    public static final TextEncodingOptions DEFAULT_SIMPLE_OPTIONS = TextEncodingOptions.builder().build();
    private final Slice nullSequence;
    private final NestingLevels nestingLevels;
    private final Slice separators;
    private final Byte escapeByte;
    private final boolean lastColumnTakesRest;
    private final List<String> timestampFormats;

    private TextEncodingOptions(Slice nullSequence, NestingLevels nestingLevels, Slice separators, Byte escapeByte, boolean lastColumnTakesRest, List<String> timestampFormats) {
        this.nullSequence = nullSequence;
        this.nestingLevels = nestingLevels;
        this.separators = separators;
        this.escapeByte = escapeByte;
        this.lastColumnTakesRest = lastColumnTakesRest;
        this.timestampFormats = timestampFormats;
    }

    public Slice getNullSequence() {
        return this.nullSequence;
    }

    public NestingLevels getNestingLevels() {
        return this.nestingLevels;
    }

    public Slice getSeparators() {
        return this.separators;
    }

    public Byte getEscapeByte() {
        return this.escapeByte;
    }

    public boolean isLastColumnTakesRest() {
        return this.lastColumnTakesRest;
    }

    public List<String> getTimestampFormats() {
        return this.timestampFormats;
    }

    public Map<String, String> toSchema() {
        ImmutableMap.Builder schema = ImmutableMap.builder();
        if (this.nestingLevels.getTableProperty() != null) {
            schema.put((Object)this.nestingLevels.getTableProperty(), (Object)"true");
        }
        this.addSeparatorProperty((ImmutableMap.Builder<String, String>)schema, 0, FIELD_DELIMITER_KEY);
        this.addSeparatorProperty((ImmutableMap.Builder<String, String>)schema, 1, COLLECTION_DELIMITER_KEY);
        this.addSeparatorProperty((ImmutableMap.Builder<String, String>)schema, 2, MAP_KEY_DELIMITER_KEY);
        if (!DEFAULT_NULL_SEQUENCE.equals((Object)this.nullSequence)) {
            schema.put((Object)NULL_FORMAT_KEY, (Object)this.nullSequence.toStringUtf8());
        }
        if (this.lastColumnTakesRest) {
            schema.put((Object)LAST_COLUMN_TAKES_REST_KEY, (Object)"true");
        }
        if (this.escapeByte != null) {
            schema.put((Object)ESCAPE_CHAR_KEY, (Object)String.valueOf(this.escapeByte));
        }
        if (!this.timestampFormats.isEmpty()) {
            schema.put((Object)"timestamp.formats", (Object)this.timestampFormats.stream().map(format -> format.replace("\\", "\\\\")).map(format -> format.replace(",", "\\,")).collect(Collectors.joining(",")));
        }
        return schema.buildOrThrow();
    }

    private void addSeparatorProperty(ImmutableMap.Builder<String, String> schema, int index, String propertyName) {
        if (this.separators.getByte(index) != DEFAULT_SEPARATORS[index]) {
            schema.put((Object)propertyName, (Object)String.valueOf(this.separators.getByte(index)));
        }
    }

    public static TextEncodingOptions fromSchema(Map<String, String> serdeProperties) {
        String escapeProperty;
        String lastColumnTakesRestString;
        Builder builder = TextEncodingOptions.builder();
        if ("true".equalsIgnoreCase(serdeProperties.get(NestingLevels.EXTENDED_ADDITIONAL.getTableProperty()))) {
            builder.extendedAdditionalNestingLevels();
        } else if ("true".equalsIgnoreCase(serdeProperties.get(NestingLevels.EXTENDED.getTableProperty()))) {
            builder.extendedNestingLevels();
        }
        builder.fieldDelimiter(TextEncodingOptions.getByte(serdeProperties.getOrDefault(FIELD_DELIMITER_KEY, serdeProperties.get(FORMAT_KEY)), DEFAULT_SEPARATORS[0]));
        builder.collectionDelimiter(TextEncodingOptions.getByte(serdeProperties.getOrDefault(COLLECTION_DELIMITER_KEY, serdeProperties.get("colelction.delim")), DEFAULT_SEPARATORS[1]));
        builder.mapKeyDelimiter(TextEncodingOptions.getByte(serdeProperties.get(MAP_KEY_DELIMITER_KEY), DEFAULT_SEPARATORS[2]));
        String nullSequenceString = serdeProperties.get(NULL_FORMAT_KEY);
        if (nullSequenceString != null) {
            builder.nullSequence(Slices.utf8Slice((String)nullSequenceString));
        }
        if ("true".equalsIgnoreCase(lastColumnTakesRestString = serdeProperties.get(LAST_COLUMN_TAKES_REST_KEY))) {
            builder.lastColumnTakesRest();
        }
        if ((escapeProperty = serdeProperties.get(ESCAPE_CHAR_KEY)) != null) {
            builder.escapeByte(TextEncodingOptions.getByte(escapeProperty, (byte)92));
        }
        builder.timestampFormats(HiveFormatUtils.getTimestampFormatsSchemaProperty(serdeProperties));
        return builder.build();
    }

    private static byte getByte(String value, byte defaultValue) {
        if (Strings.isNullOrEmpty((String)value)) {
            return defaultValue;
        }
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            return (byte)value.charAt(0);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TextEncodingOptions textEncodingOptions) {
        return new Builder(textEncodingOptions);
    }

    public static enum NestingLevels {
        LEGACY(8, null),
        EXTENDED(24, "hive.serialization.extend.nesting.levels"),
        EXTENDED_ADDITIONAL(DEFAULT_SEPARATORS.length, "hive.serialization.extend.additional.nesting.levels");

        private final int levels;
        private final String tableProperty;

        private NestingLevels(int levels, String tableProperty) {
            this.levels = levels;
            this.tableProperty = tableProperty;
        }

        public int getLevels() {
            return this.levels;
        }

        public String getTableProperty() {
            return this.tableProperty;
        }

        public Slice getSeparators(byte fieldDelimiter, byte collectionDelimiter, byte mapKeyDelimiter) {
            byte[] separators = Arrays.copyOf(DEFAULT_SEPARATORS, this.levels);
            separators[0] = fieldDelimiter;
            separators[1] = collectionDelimiter;
            separators[2] = mapKeyDelimiter;
            return Slices.wrappedBuffer((byte[])separators);
        }
    }

    public static class Builder {
        private Slice nullSequence = DEFAULT_NULL_SEQUENCE;
        private NestingLevels nestingLevels = NestingLevels.LEGACY;
        private byte fieldDelimiter = DEFAULT_SEPARATORS[0];
        private byte collectionDelimiter = DEFAULT_SEPARATORS[1];
        private byte mapKeyDelimiter = DEFAULT_SEPARATORS[2];
        private Byte escapeByte;
        private boolean lastColumnTakesRest;
        private List<String> timestampFormats = ImmutableList.of();

        public Builder() {
        }

        public Builder(TextEncodingOptions textEncodingOptions) {
            this.nullSequence = textEncodingOptions.getNullSequence();
            this.nestingLevels = textEncodingOptions.getNestingLevels();
            this.fieldDelimiter = textEncodingOptions.getSeparators().getByte(0);
            this.collectionDelimiter = textEncodingOptions.getSeparators().getByte(1);
            this.mapKeyDelimiter = textEncodingOptions.getSeparators().getByte(2);
            this.escapeByte = textEncodingOptions.getEscapeByte();
            this.lastColumnTakesRest = textEncodingOptions.isLastColumnTakesRest();
            this.timestampFormats = textEncodingOptions.getTimestampFormats();
        }

        public Builder nullSequence(Slice nullSequence) {
            this.nullSequence = nullSequence;
            return this;
        }

        public Builder extendedNestingLevels() {
            return this.nestingLevels(NestingLevels.EXTENDED);
        }

        public Builder extendedAdditionalNestingLevels() {
            return this.nestingLevels(NestingLevels.EXTENDED_ADDITIONAL);
        }

        public Builder nestingLevels(NestingLevels nestingLevels) {
            this.nestingLevels = nestingLevels;
            return this;
        }

        public Builder fieldDelimiter(byte fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
            return this;
        }

        public Builder collectionDelimiter(byte collectionDelimiter) {
            this.collectionDelimiter = collectionDelimiter;
            return this;
        }

        public Builder mapKeyDelimiter(byte mapKeyDelimiter) {
            this.mapKeyDelimiter = mapKeyDelimiter;
            return this;
        }

        public Builder escapeByte(byte escapeByte) {
            this.escapeByte = escapeByte;
            return this;
        }

        public Builder lastColumnTakesRest() {
            this.lastColumnTakesRest = true;
            return this;
        }

        public Builder timestampFormats(String ... timestampFormats) {
            return this.timestampFormats((List<String>)ImmutableList.copyOf((Object[])timestampFormats));
        }

        public Builder timestampFormats(List<String> timestampFormats) {
            this.timestampFormats = timestampFormats;
            return this;
        }

        public TextEncodingOptions build() {
            Slice separators = this.nestingLevels.getSeparators(this.fieldDelimiter, this.collectionDelimiter, this.mapKeyDelimiter);
            return new TextEncodingOptions(this.nullSequence, this.nestingLevels, separators, this.escapeByte, this.lastColumnTakesRest, this.timestampFormats);
        }
    }
}

