/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line.csv;

import io.trino.hive.formats.line.Column;
import io.trino.hive.formats.line.LineDeserializer;
import io.trino.hive.formats.line.LineDeserializerFactory;
import io.trino.hive.formats.line.csv.CsvConstants;
import io.trino.hive.formats.line.csv.CsvDeserializer;
import java.util.List;
import java.util.Map;

public class CsvDeserializerFactory
implements LineDeserializerFactory {
    @Override
    public List<String> getHiveSerDeClassNames() {
        return CsvConstants.HIVE_SERDE_CLASS_NAMES;
    }

    @Override
    public LineDeserializer create(List<Column> columns, Map<String, String> serdeProperties) {
        char separatorChar = CsvConstants.getCharProperty(serdeProperties, "separatorChar", (byte)44);
        char quoteChar = CsvConstants.getCharProperty(serdeProperties, "quoteChar", (byte)34);
        char escapeChar = CsvConstants.getCharProperty(serdeProperties, "escapeChar", (byte)92);
        return new CsvDeserializer(columns, separatorChar, quoteChar, escapeChar);
    }
}

