/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.avro.model;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.hive.formats.avro.AvroPageDataReader;
import io.trino.hive.formats.avro.AvroTypeException;
import io.trino.hive.formats.avro.model.ArrayReadAction;
import io.trino.hive.formats.avro.model.BooleanRead;
import io.trino.hive.formats.avro.model.BytesRead;
import io.trino.hive.formats.avro.model.DefaultValueFieldRecordFieldReadAction;
import io.trino.hive.formats.avro.model.DoubleRead;
import io.trino.hive.formats.avro.model.EnumReadAction;
import io.trino.hive.formats.avro.model.FixedRead;
import io.trino.hive.formats.avro.model.FloatRead;
import io.trino.hive.formats.avro.model.IntRead;
import io.trino.hive.formats.avro.model.LongRead;
import io.trino.hive.formats.avro.model.MapReadAction;
import io.trino.hive.formats.avro.model.NullRead;
import io.trino.hive.formats.avro.model.ReadErrorReadAction;
import io.trino.hive.formats.avro.model.ReadFieldAction;
import io.trino.hive.formats.avro.model.ReadingUnionReadAction;
import io.trino.hive.formats.avro.model.RecordFieldReadAction;
import io.trino.hive.formats.avro.model.RecordReadAction;
import io.trino.hive.formats.avro.model.SkipFieldRecordFieldReadAction;
import io.trino.hive.formats.avro.model.StringRead;
import io.trino.hive.formats.avro.model.WrittenUnionReadAction;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.avro.Resolver;
import org.apache.avro.Schema;

public sealed interface AvroReadAction
permits NullRead, BooleanRead, IntRead, LongRead, FloatRead, DoubleRead, StringRead, BytesRead, FixedRead, ArrayReadAction, EnumReadAction, MapReadAction, ReadingUnionReadAction, RecordReadAction, WrittenUnionReadAction, ReadErrorReadAction {
    public Schema readSchema();

    public Schema writeSchema();

    public static AvroReadAction fromAction(Resolver.Action action) throws AvroTypeException {
        return switch (action.type) {
            default -> throw new MatchException(null, null);
            case Resolver.Action.Type.DO_NOTHING -> {
                switch (action.reader.getType()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NULL: {
                        yield new NullRead(action.reader, action.writer);
                    }
                    case BOOLEAN: {
                        yield new BooleanRead(action.reader, action.writer);
                    }
                    case INT: {
                        yield new IntRead(action.reader, action.writer);
                    }
                    case LONG: {
                        yield new LongRead(action.reader, action.writer);
                    }
                    case FLOAT: {
                        yield new FloatRead(action.reader, action.writer);
                    }
                    case DOUBLE: {
                        yield new DoubleRead(action.reader, action.writer);
                    }
                    case STRING: {
                        yield new StringRead(action.reader, action.writer);
                    }
                    case BYTES: {
                        yield new BytesRead(action.reader, action.writer);
                    }
                    case FIXED: {
                        yield new FixedRead(action.reader, action.writer);
                    }
                    case ENUM: 
                    case ARRAY: 
                    case MAP: 
                    case RECORD: 
                    case UNION: 
                }
                throw new IllegalStateException("Underlying Avro Library change detected with action: " + String.valueOf(action));
            }
            case Resolver.Action.Type.PROMOTE -> {
                switch (action.reader.getType()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case LONG: {
                        yield new LongRead(action.reader, action.writer);
                    }
                    case FLOAT: {
                        yield new FloatRead(action.reader, action.writer);
                    }
                    case DOUBLE: {
                        yield new DoubleRead(action.reader, action.writer);
                    }
                    case STRING: {
                        if (action.writer.getType() == Schema.Type.BYTES) {
                            yield new StringRead(action.reader, action.writer);
                        }
                        throw new IllegalStateException("Unable to promote to String from type " + String.valueOf(action.writer.getType()));
                    }
                    case BYTES: {
                        if (action.writer.getType() == Schema.Type.STRING) {
                            yield new BytesRead(action.reader, action.writer);
                        }
                        throw new IllegalStateException("Unable to promote to Bytes from type " + String.valueOf(action.writer.getType()));
                    }
                    case NULL: 
                    case BOOLEAN: 
                    case INT: 
                    case FIXED: 
                    case ENUM: 
                    case ARRAY: 
                    case MAP: 
                    case RECORD: 
                    case UNION: 
                }
                throw new IllegalStateException("Promotion action not allowed for reader schema type " + String.valueOf(action.reader.getType()));
            }
            case Resolver.Action.Type.CONTAINER -> {
                switch (action.reader.getType()) {
                    case ARRAY: {
                        yield new ArrayReadAction(action.reader, action.writer, AvroReadAction.fromAction(((Resolver.Container)action).elementAction));
                    }
                    case MAP: {
                        yield new MapReadAction(action.reader, action.writer, AvroReadAction.fromAction(((Resolver.Container)action).elementAction));
                    }
                }
                throw new IllegalStateException("Not possible to have container action type with non container reader schema " + String.valueOf(action.reader.getType()));
            }
            case Resolver.Action.Type.ENUM -> new EnumReadAction(action.reader, action.writer, AvroReadAction.getSymbolIndex((Resolver.EnumAdjust)action));
            case Resolver.Action.Type.RECORD -> AvroReadAction.recordReadAction(action.reader, action.writer, (Resolver.RecordAdjust)action);
            case Resolver.Action.Type.WRITER_UNION -> AvroReadAction.fromWrittenUnionAction((Resolver.WriterUnion)action);
            case Resolver.Action.Type.READER_UNION -> AvroReadAction.fromReaderUnionAction((Resolver.ReaderUnion)action);
            case Resolver.Action.Type.ERROR -> new ReadErrorReadAction(action.reader, action.writer, ((Resolver.ErrorAction)action).error, action.toString());
            case Resolver.Action.Type.SKIP -> throw new IllegalStateException("Skips recordReadAction");
        };
    }

    private static RecordReadAction recordReadAction(Schema readSchema, Schema writeSchema, Resolver.RecordAdjust recordAdjust) throws AvroTypeException {
        int i;
        Object[] buildSteps = new RecordFieldReadAction[recordAdjust.fieldActions.length + recordAdjust.readerOrder.length - recordAdjust.firstDefault];
        int readerFieldCount = 0;
        for (i = 0; i < recordAdjust.fieldActions.length; ++i) {
            Resolver.Action fieldAction2 = recordAdjust.fieldActions[i];
            if (fieldAction2 instanceof Resolver.Skip) {
                Resolver.Skip skip = (Resolver.Skip)fieldAction2;
                buildSteps[i] = new SkipFieldRecordFieldReadAction(AvroPageDataReader.RowBlockBuildingDecoder.SkipSchemaBuildingAction.createSkipActionForSchema(skip.writer));
                continue;
            }
            Schema.Field readField = recordAdjust.readerOrder[readerFieldCount++];
            buildSteps[i] = new ReadFieldAction(AvroReadAction.fromAction(fieldAction2), readField.pos());
        }
        while (i < buildSteps.length) {
            Schema.Field readField = recordAdjust.readerOrder[readerFieldCount++];
            buildSteps[i] = new DefaultValueFieldRecordFieldReadAction(readField.schema(), AvroPageDataReader.getDefaultByes(readField), readField.pos());
            ++i;
        }
        Verify.verify((Arrays.stream(buildSteps).mapToInt(fieldAction -> {
            RecordFieldReadAction recordFieldReadAction = fieldAction;
            Objects.requireNonNull(recordFieldReadAction);
            RecordFieldReadAction selector0$temp = recordFieldReadAction;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DefaultValueFieldRecordFieldReadAction.class, ReadFieldAction.class, SkipFieldRecordFieldReadAction.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    DefaultValueFieldRecordFieldReadAction a = (DefaultValueFieldRecordFieldReadAction)selector0$temp;
                    yield a.outputChannel();
                }
                case 1 -> {
                    ReadFieldAction b = (ReadFieldAction)selector0$temp;
                    yield b.outputChannel();
                }
                case 2 -> {
                    SkipFieldRecordFieldReadAction ignore = (SkipFieldRecordFieldReadAction)selector0$temp;
                    yield -1;
                }
            };
        }).filter(a -> a >= 0).distinct().sum() == recordAdjust.reader.getFields().size() * (recordAdjust.reader.getFields().size() - 1) / 2 ? 1 : 0) != 0, (String)"Every channel in output block builder must be accounted for", (Object[])new Object[0]);
        Verify.verify((Arrays.stream(buildSteps).mapToInt(fieldAction -> {
            RecordFieldReadAction recordFieldReadAction = fieldAction;
            Objects.requireNonNull(recordFieldReadAction);
            RecordFieldReadAction selector0$temp = recordFieldReadAction;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DefaultValueFieldRecordFieldReadAction.class, ReadFieldAction.class, SkipFieldRecordFieldReadAction.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    DefaultValueFieldRecordFieldReadAction a = (DefaultValueFieldRecordFieldReadAction)selector0$temp;
                    yield a.outputChannel();
                }
                case 1 -> {
                    ReadFieldAction b = (ReadFieldAction)selector0$temp;
                    yield b.outputChannel();
                }
                case 2 -> {
                    SkipFieldRecordFieldReadAction ignore = (SkipFieldRecordFieldReadAction)selector0$temp;
                    yield -1;
                }
            };
        }).filter(a -> a >= 0).distinct().count() == (long)recordAdjust.reader.getFields().size() ? 1 : 0) != 0, (String)"Every channel in output block builder must be accounted for", (Object[])new Object[0]);
        return new RecordReadAction(readSchema, writeSchema, (List<RecordFieldReadAction>)ImmutableList.copyOf((Object[])buildSteps));
    }

    private static List<Slice> getSymbolIndex(Resolver.EnumAdjust action) throws AvroTypeException {
        List symbolsList = Objects.requireNonNull(action, (String)"action is null").reader.getEnumSymbols();
        Object[] symbols = (Slice[])symbolsList.stream().map(Slices::utf8Slice).toArray(Slice[]::new);
        if (!action.noAdjustmentsNeeded) {
            Slice[] adjustedSymbols = new Slice[action.writer.getEnumSymbols().size()];
            for (int i = 0; i < action.adjustments.length; ++i) {
                if (action.adjustments[i] < 0) {
                    throw new AvroTypeException("No reader Enum value for writer Enum value " + (String)action.writer.getEnumSymbols().get(i));
                }
                adjustedSymbols[i] = symbols[action.adjustments[i]];
            }
            symbols = adjustedSymbols;
        }
        return ImmutableList.copyOf((Object[])symbols);
    }

    private static WrittenUnionReadAction fromWrittenUnionAction(Resolver.WriterUnion writerUnion) throws AvroTypeException {
        Object[] readActions = new AvroReadAction[writerUnion.actions.length];
        for (int i = 0; i < writerUnion.actions.length; ++i) {
            readActions[i] = AvroReadAction.fromAction(writerUnion.actions[i]);
        }
        return new WrittenUnionReadAction(writerUnion.reader, writerUnion.writer, writerUnion.unionEquiv, (List<AvroReadAction>)ImmutableList.copyOf((Object[])readActions));
    }

    private static ReadingUnionReadAction fromReaderUnionAction(Resolver.ReaderUnion readerUnion) throws AvroTypeException {
        return new ReadingUnionReadAction(readerUnion.reader, readerUnion.writer, readerUnion.firstMatch, AvroReadAction.fromAction(readerUnion.actualAction));
    }
}

