/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line.csv;

import com.google.common.base.Preconditions;
import io.trino.hive.formats.line.Column;
import io.trino.hive.formats.line.LineDeserializer;
import io.trino.hive.formats.line.LineDeserializerFactory;
import io.trino.hive.formats.line.csv.CsvConstants;
import io.trino.hive.formats.line.csv.CsvDeserializer;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CsvDeserializerFactory
implements LineDeserializerFactory {
    @Override
    public Set<String> getHiveSerDeClassNames() {
        return CsvConstants.HIVE_SERDE_CLASS_NAMES;
    }

    @Override
    public LineDeserializer create(List<Column> columns, Map<String, String> serdeProperties) {
        char separatorChar = CsvConstants.getCharProperty(serdeProperties, "separatorChar", (byte)44);
        char quoteChar = CsvConstants.getCharProperty(serdeProperties, "quoteChar", (byte)34);
        int escapeChar = CsvConstants.getCharProperty(serdeProperties, "escapeChar", (byte)92);
        if (escapeChar == 34) {
            Preconditions.checkArgument((separatorChar != '\\' ? 1 : 0) != 0, (Object)"Separator character cannot be '\\' when escape character is '\"'");
            Preconditions.checkArgument((quoteChar != '\\' ? 1 : 0) != 0, (Object)"Quote character cannot be '\\' when escape character is '\"'");
            escapeChar = 92;
        }
        return new CsvDeserializer(columns, separatorChar, quoteChar, (char)escapeChar);
    }
}

