/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line.regex;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.hive.formats.HiveFormatUtils;
import io.trino.hive.formats.line.Column;
import io.trino.hive.formats.line.LineBuffer;
import io.trino.hive.formats.line.LineDeserializer;
import io.trino.plugin.base.type.DecodedTimestamp;
import io.trino.plugin.base.type.TrinoTimestampEncoderFactory;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalConversions;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.spi.type.Varchars;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTimeZone;

public class RegexDeserializer
implements LineDeserializer {
    private final Pattern inputPattern;
    private final List<Column> columns;

    public RegexDeserializer(List<Column> columns, String regex, boolean caseSensitive) {
        this.inputPattern = Pattern.compile(regex, 32 + (caseSensitive ? 2 : 0));
        this.columns = ImmutableList.copyOf(columns);
    }

    @Override
    public List<? extends Type> getTypes() {
        return (List)this.columns.stream().map(Column::type).collect(ImmutableList.toImmutableList());
    }

    @Override
    public void deserialize(LineBuffer lineBuffer, PageBuilder builder) throws IOException {
        Matcher matcher = this.inputPattern.matcher(new String(lineBuffer.getBuffer(), 0, lineBuffer.getLength(), StandardCharsets.UTF_8));
        builder.declarePosition();
        if (!matcher.matches()) {
            for (int i = 0; i < this.columns.size(); ++i) {
                builder.getBlockBuilder(i).appendNull();
            }
            return;
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            String value;
            Column column = this.columns.get(i);
            int ordinal = column.ordinal();
            BlockBuilder blockBuilder = builder.getBlockBuilder(i);
            String string = value = ordinal < matcher.groupCount() ? matcher.group(ordinal + 1) : null;
            if (value == null) {
                blockBuilder.appendNull();
                continue;
            }
            RegexDeserializer.serializeValue(value, column, blockBuilder);
        }
    }

    private static void serializeValue(String value, Column column, BlockBuilder builder) {
        block15: {
            try {
                Type type = column.type();
                if (BooleanType.BOOLEAN.equals((Object)type)) {
                    type.writeBoolean(builder, Boolean.parseBoolean(value));
                    break block15;
                }
                if (BigintType.BIGINT.equals((Object)type)) {
                    type.writeLong(builder, Long.parseLong(value));
                    break block15;
                }
                if (IntegerType.INTEGER.equals((Object)type)) {
                    type.writeLong(builder, (long)Integer.parseInt(value));
                    break block15;
                }
                if (SmallintType.SMALLINT.equals((Object)type)) {
                    type.writeLong(builder, (long)Short.parseShort(value));
                    break block15;
                }
                if (TinyintType.TINYINT.equals((Object)type)) {
                    type.writeLong(builder, (long)Byte.parseByte(value));
                    break block15;
                }
                if (type instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)type;
                    RegexDeserializer.serializeDecimal(value, decimalType, builder);
                    break block15;
                }
                if (RealType.REAL.equals((Object)type)) {
                    type.writeLong(builder, (long)Float.floatToRawIntBits(Float.parseFloat(value)));
                    break block15;
                }
                if (DoubleType.DOUBLE.equals((Object)type)) {
                    type.writeDouble(builder, Double.parseDouble(value));
                    break block15;
                }
                if (DateType.DATE.equals((Object)type)) {
                    type.writeLong(builder, (long)StrictMath.toIntExact(HiveFormatUtils.parseHiveDate(value).toEpochDay()));
                    break block15;
                }
                if (type instanceof TimestampType) {
                    TimestampType timestampType = (TimestampType)type;
                    DecodedTimestamp timestamp = HiveFormatUtils.parseHiveTimestamp(value);
                    TrinoTimestampEncoderFactory.createTimestampEncoder((TimestampType)timestampType, (DateTimeZone)DateTimeZone.UTC).write(timestamp, builder);
                    break block15;
                }
                if (type instanceof VarcharType) {
                    VarcharType varcharType = (VarcharType)type;
                    type.writeSlice(builder, Varchars.truncateToLength((Slice)Slices.utf8Slice((String)value), (VarcharType)varcharType));
                    break block15;
                }
                if (type instanceof CharType) {
                    CharType charType = (CharType)type;
                    type.writeSlice(builder, Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)value), (CharType)charType));
                    break block15;
                }
                throw new UnsupportedTypeException(column);
            }
            catch (UnsupportedTypeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                builder.appendNull();
            }
        }
    }

    private static void serializeDecimal(String value, DecimalType decimalType, BlockBuilder builder) {
        BigDecimal bigDecimal;
        try {
            bigDecimal = new BigDecimal(value).setScale(DecimalConversions.intScale((long)decimalType.getScale()), RoundingMode.HALF_UP);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.format("Cannot convert '%s' to %s. Value is not a number.", value, decimalType));
        }
        if (Decimals.overflows((BigDecimal)bigDecimal, (long)decimalType.getPrecision())) {
            throw new IllegalArgumentException(String.format("Cannot convert '%s' to %s. Value too large.", value, decimalType));
        }
        if (decimalType.isShort()) {
            decimalType.writeLong(builder, bigDecimal.unscaledValue().longValueExact());
        } else {
            decimalType.writeObject(builder, (Object)Int128.valueOf((BigInteger)bigDecimal.unscaledValue()));
        }
    }

    public static class UnsupportedTypeException
    extends RuntimeException {
        private final Column column;

        public UnsupportedTypeException(Column column) {
            super("Unsupported column type: " + String.valueOf(column));
            this.column = column;
        }

        public Column getColumn() {
            return this.column;
        }
    }
}

