/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line.simple;

import com.google.common.base.Splitter;
import io.trino.hive.formats.encodings.text.TextEncodingOptions;
import io.trino.hive.formats.line.Column;
import io.trino.hive.formats.line.LineDeserializer;
import io.trino.hive.formats.line.LineDeserializerFactory;
import io.trino.hive.formats.line.simple.SimpleConstants;
import io.trino.hive.formats.line.simple.SimpleDeserializer;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimpleDeserializerFactory
implements LineDeserializerFactory {
    private static final Splitter COLUMN_NAMES_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private static final String LIST_COLUMNS = "columns";

    @Override
    public Set<String> getHiveSerDeClassNames() {
        return SimpleConstants.HIVE_SERDE_CLASS_NAMES;
    }

    @Override
    public LineDeserializer create(List<Column> columns, Map<String, String> serdeProperties) {
        int tableColumnCount = COLUMN_NAMES_SPLITTER.splitToList((CharSequence)serdeProperties.getOrDefault(LIST_COLUMNS, "")).size();
        TextEncodingOptions textEncodingOptions = TextEncodingOptions.fromSchema(serdeProperties);
        return new SimpleDeserializer(columns, textEncodingOptions, tableColumnCount);
    }
}

