/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.type.MapType;
import java.util.Arrays;

public class DistinctMapKeys {
    private static final int HASH_MULTIPLIER = 2;
    private final MapType mapType;
    private final boolean userLastEntry;
    private boolean[] distinctBuffer = new boolean[0];
    private int[] hashTableBuffer = new int[0];

    public DistinctMapKeys(MapType mapType, boolean userLastEntry) {
        this.mapType = mapType;
        this.userLastEntry = userLastEntry;
    }

    public boolean[] selectDistinctKeys(Block keyBlock) {
        int keyCount = keyBlock.getPositionCount();
        int hashTableSize = keyCount * 2;
        if (this.distinctBuffer.length < keyCount) {
            this.distinctBuffer = new boolean[DistinctMapKeys.calculateBufferSize(keyCount)];
        }
        if (this.hashTableBuffer.length < hashTableSize) {
            this.hashTableBuffer = new int[DistinctMapKeys.calculateBufferSize(hashTableSize)];
        }
        boolean[] distinct = this.distinctBuffer;
        Arrays.fill(distinct, false);
        int[] hashTable = this.hashTableBuffer;
        Arrays.fill(hashTable, -1);
        block3: for (int i = 0; i < keyCount; ++i) {
            if (keyBlock.isNull(i)) continue;
            int hash = this.getHashPosition(keyBlock, i, hashTableSize);
            while (true) {
                Boolean isDuplicateKey;
                if (hashTable[hash] == -1) {
                    hashTable[hash] = i;
                    distinct[i] = true;
                    continue block3;
                }
                try {
                    isDuplicateKey = this.mapType.getKeyBlockEqual().invokeExact(keyBlock, i, keyBlock, hashTable[hash]);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
                if (isDuplicateKey == null) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "map key cannot be null or contain nulls");
                }
                if (isDuplicateKey.booleanValue()) {
                    if (!this.userLastEntry) continue block3;
                    int duplicateIndex = hashTable[hash];
                    distinct[duplicateIndex] = false;
                    hashTable[hash] = i;
                    distinct[i] = true;
                    continue block3;
                }
                if (++hash != hashTableSize) continue;
                hash = 0;
            }
        }
        return distinct;
    }

    private int getHashPosition(Block keyBlock, int position, int hashTableSize) {
        long hashCode;
        if (keyBlock.isNull(position)) {
            throw new IllegalArgumentException("map keys cannot be null");
        }
        try {
            hashCode = this.mapType.getKeyBlockHashCode().invokeExact(keyBlock, position);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return DistinctMapKeys.computePosition(hashCode, hashTableSize);
    }

    private static int computePosition(long hashcode, int hashTableSize) {
        return (int)(Integer.toUnsignedLong(Long.hashCode(hashcode)) * (long)hashTableSize >> 32);
    }

    private static int calculateBufferSize(int value) {
        if (value < 128) {
            return 128;
        }
        int highestOneBit = Integer.highestOneBit(value);
        if (value == highestOneBit) {
            return value;
        }
        return highestOneBit << 1;
    }
}

