/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.avro;

import com.google.common.base.Verify;
import io.trino.annotation.NotThreadSafe;
import io.trino.hive.formats.avro.AvroTypeBlockHandler;
import io.trino.hive.formats.avro.AvroTypeException;
import io.trino.hive.formats.avro.BaseAvroTypeBlockHandlerImpls;
import io.trino.hive.formats.avro.BlockBuildingDecoder;
import io.trino.hive.formats.avro.NativeLogicalTypesAvroTypeManager;
import io.trino.hive.formats.avro.model.AvroLogicalType;
import io.trino.hive.formats.avro.model.AvroReadAction;
import io.trino.hive.formats.avro.model.BytesRead;
import io.trino.hive.formats.avro.model.FixedRead;
import io.trino.hive.formats.avro.model.IntRead;
import io.trino.hive.formats.avro.model.LongRead;
import io.trino.hive.formats.avro.model.StringRead;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;

public class NativeLogicalTypesAvroTypeBlockHandler
implements AvroTypeBlockHandler {
    @Override
    public void configure(Map<String, byte[]> fileMetadata) {
    }

    @Override
    public Type typeFor(Schema schema) throws AvroTypeException {
        Optional<Type> avroLogicalTypeTrinoType = NativeLogicalTypesAvroTypeManager.validateAndLogIssues(schema).map(NativeLogicalTypesAvroTypeManager::getAvroLogicalTypeSpiType);
        if (avroLogicalTypeTrinoType.isPresent()) {
            return avroLogicalTypeTrinoType.get();
        }
        return BaseAvroTypeBlockHandlerImpls.baseTypeFor(schema, this);
    }

    @Override
    public BlockBuildingDecoder blockBuildingDecoderFor(AvroReadAction readAction) throws AvroTypeException {
        Optional<AvroLogicalType> avroLogicalType = NativeLogicalTypesAvroTypeManager.validateAndLogIssues(readAction.readSchema());
        if (avroLogicalType.isPresent()) {
            return NativeLogicalTypesAvroTypeBlockHandler.getLogicalTypeBuildingFunction(avroLogicalType.get(), readAction);
        }
        return BaseAvroTypeBlockHandlerImpls.baseBlockBuildingDecoderFor(readAction, this);
    }

    static BlockBuildingDecoder getLogicalTypeBuildingFunction(AvroLogicalType logicalType, AvroReadAction readAction) {
        AvroLogicalType avroLogicalType = logicalType;
        Objects.requireNonNull(avroLogicalType);
        AvroLogicalType avroLogicalType2 = avroLogicalType;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AvroLogicalType.DateLogicalType.class, AvroLogicalType.BytesDecimalLogicalType.class, AvroLogicalType.FixedDecimalLogicalType.class, AvroLogicalType.TimeMillisLogicalType.class, AvroLogicalType.TimeMicrosLogicalType.class, AvroLogicalType.TimestampMillisLogicalType.class, AvroLogicalType.TimestampMicrosLogicalType.class, AvroLogicalType.StringUUIDLogicalType.class}, (Object)avroLogicalType2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (readAction instanceof IntRead) {
                    yield new DateBlockBuildingDecoder();
                }
                throw new IllegalStateException("Unreachable unfiltered logical type");
            }
            case 1 -> {
                AvroLogicalType.BytesDecimalLogicalType bytesDecimalLogicalType = (AvroLogicalType.BytesDecimalLogicalType)avroLogicalType2;
                if (readAction instanceof BytesRead) {
                    yield new BytesDecimalBlockBuildingDecoder(DecimalType.createDecimalType((int)bytesDecimalLogicalType.precision(), (int)bytesDecimalLogicalType.scale()));
                }
                throw new IllegalStateException("Unreachable unfiltered logical type");
            }
            case 2 -> {
                AvroLogicalType.FixedDecimalLogicalType fixedDecimalLogicalType = (AvroLogicalType.FixedDecimalLogicalType)avroLogicalType2;
                if (readAction instanceof FixedRead) {
                    yield new FixedDecimalBlockBuildingDecoder(DecimalType.createDecimalType((int)fixedDecimalLogicalType.precision(), (int)fixedDecimalLogicalType.scale()), fixedDecimalLogicalType.fixedSize());
                }
                throw new IllegalStateException("Unreachable unfiltered logical type");
            }
            case 3 -> {
                if (readAction instanceof IntRead) {
                    yield new TimeMillisBlockBuildingDecoder();
                }
                throw new IllegalStateException("Unreachable unfiltered logical type");
            }
            case 4 -> {
                if (readAction instanceof LongRead) {
                    yield new TimeMicrosBlockBuildingDecoder();
                }
                throw new IllegalStateException("Unreachable unfiltered logical type");
            }
            case 5 -> {
                if (readAction instanceof LongRead) {
                    LongRead longRead = (LongRead)readAction;
                    yield new TimestampMillisBlockBuildingDecoder(longRead);
                }
                throw new IllegalStateException("Unreachable unfiltered logical type");
            }
            case 6 -> {
                if (readAction instanceof LongRead) {
                    LongRead longRead = (LongRead)readAction;
                    yield new TimestampMicrosBlockBuildingDecoder(longRead);
                }
                throw new IllegalStateException("Unreachable unfiltered logical type");
            }
            case 7 -> {
                if (readAction instanceof StringRead) {
                    yield new StringUUIDBlockBuildingDecoder();
                }
                throw new IllegalStateException("Unreachable unfiltered logical type");
            }
        };
    }

    public record DateBlockBuildingDecoder() implements BlockBuildingDecoder
    {
        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            DateType.DATE.writeLong(builder, (long)decoder.readInt());
        }
    }

    public record BytesDecimalBlockBuildingDecoder(DecimalType decimalType) implements BlockBuildingDecoder
    {
        public BytesDecimalBlockBuildingDecoder {
            Objects.requireNonNull(decimalType, "decimalType is null");
        }

        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            long size = decoder.readLong();
            if (size > 0x7FFFFFF7L) {
                throw new IOException("Unable to read avro Bytes with size greater than %s. Found Bytes size: %s".formatted(0x7FFFFFF7L, size));
            }
            byte[] bytes = new byte[(int)size];
            decoder.readFixed(bytes);
            if (this.decimalType.isShort()) {
                this.decimalType.writeLong(builder, NativeLogicalTypesAvroTypeManager.fromBigEndian(bytes));
            } else {
                this.decimalType.writeObject(builder, (Object)Int128.fromBigEndian((byte[])bytes));
            }
        }
    }

    @NotThreadSafe
    public static class FixedDecimalBlockBuildingDecoder
    implements BlockBuildingDecoder {
        private final DecimalType decimalType;
        private final byte[] bytes;

        public FixedDecimalBlockBuildingDecoder(DecimalType decimalType, int fixedSize) {
            this.decimalType = Objects.requireNonNull(decimalType, "decimalType is null");
            Verify.verify((fixedSize > 0 ? 1 : 0) != 0, (String)"fixedSize must be over 0", (Object[])new Object[0]);
            this.bytes = new byte[fixedSize];
        }

        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            decoder.readFixed(this.bytes);
            if (this.decimalType.isShort()) {
                this.decimalType.writeLong(builder, NativeLogicalTypesAvroTypeManager.fromBigEndian(this.bytes));
            } else {
                this.decimalType.writeObject(builder, (Object)Int128.fromBigEndian((byte[])this.bytes));
            }
        }
    }

    public record TimeMillisBlockBuildingDecoder() implements BlockBuildingDecoder
    {
        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            TimeType.TIME_MILLIS.writeLong(builder, (long)decoder.readInt() * 1000000000L);
        }
    }

    public record TimeMicrosBlockBuildingDecoder() implements BlockBuildingDecoder
    {
        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            TimeType.TIME_MICROS.writeLong(builder, decoder.readLong() * 1000000L);
        }
    }

    public static class TimestampMillisBlockBuildingDecoder
    implements BlockBuildingDecoder {
        private final AvroReadAction.LongIoFunction<Decoder> longDecoder;

        public TimestampMillisBlockBuildingDecoder(LongRead longRead) {
            this.longDecoder = Objects.requireNonNull(longRead, "longRead is null").getLongDecoder();
        }

        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            TimestampType.TIMESTAMP_MILLIS.writeLong(builder, this.longDecoder.apply(decoder) * 1000L);
        }
    }

    public static class TimestampMicrosBlockBuildingDecoder
    implements BlockBuildingDecoder {
        private final AvroReadAction.LongIoFunction<Decoder> longDecoder;

        public TimestampMicrosBlockBuildingDecoder(LongRead longRead) {
            this.longDecoder = Objects.requireNonNull(longRead, "longRead is null").getLongDecoder();
        }

        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            TimestampType.TIMESTAMP_MICROS.writeLong(builder, this.longDecoder.apply(decoder));
        }
    }

    public record StringUUIDBlockBuildingDecoder() implements BlockBuildingDecoder
    {
        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            long size = decoder.readLong();
            if (size > 0x7FFFFFF7L) {
                throw new IOException("Unable to read avro String with size greater than %s. Found String size: %s".formatted(0x7FFFFFF7L, size));
            }
            byte[] bytes = new byte[(int)size];
            decoder.readFixed(bytes);
            UuidType.UUID.writeSlice(builder, UuidType.javaUuidToTrinoUuid((UUID)UUID.fromString(new String(bytes, StandardCharsets.UTF_8))));
        }
    }
}

