/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.encodings.text;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.hive.formats.HiveFormatUtils;
import io.trino.hive.formats.encodings.ColumnData;
import io.trino.hive.formats.encodings.EncodeOutput;
import io.trino.hive.formats.encodings.text.TextColumnEncoding;
import io.trino.plugin.base.type.DecodedTimestamp;
import io.trino.plugin.base.type.TrinoTimestampEncoder;
import io.trino.plugin.base.type.TrinoTimestampEncoderFactory;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.joda.time.DateTimeZone;

public class TimestampEncoding
implements TextColumnEncoding {
    private final TimestampType type;
    private final Slice nullSequence;
    private final Function<String, DecodedTimestamp> timestampParser;
    private final TrinoTimestampEncoder<?> trinoTimestampEncoder;
    private final StringBuilder buffer = new StringBuilder();

    public TimestampEncoding(TimestampType type, Slice nullSequence, List<String> timestampFormats) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.nullSequence = Objects.requireNonNull(nullSequence, "nullSequence is null");
        this.timestampParser = HiveFormatUtils.createTimestampParser(timestampFormats);
        this.trinoTimestampEncoder = TrinoTimestampEncoderFactory.createTimestampEncoder((TimestampType)type, (DateTimeZone)DateTimeZone.UTC);
    }

    @Override
    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                output.writeBytes(this.nullSequence);
            } else {
                this.encodeValue(block, position, output);
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public void encodeValueInto(Block block, int position, SliceOutput output) {
        this.encodeValue(block, position, output);
    }

    private void encodeValue(Block block, int position, SliceOutput output) {
        this.buffer.setLength(0);
        HiveFormatUtils.formatHiveTimestamp((Type)this.type, block, position, this.buffer);
        for (int index = 0; index < this.buffer.length(); ++index) {
            output.writeByte((int)this.buffer.charAt(index));
        }
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int offset = columnData.getOffset(i);
            int length = columnData.getLength(i);
            if (length == 0 || this.nullSequence.equals(0, this.nullSequence.length(), slice, offset, length)) {
                builder.appendNull();
                continue;
            }
            this.decodeValue(builder, slice, offset, length);
        }
        return builder.build();
    }

    @Override
    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) {
        this.decodeValue(builder, slice, offset, length);
    }

    private void decodeValue(BlockBuilder builder, Slice slice, int offset, int length) {
        if (length < 8) {
            builder.appendNull();
            return;
        }
        try {
            DecodedTimestamp decodedTimestamp = this.timestampParser.apply(slice.toStringAscii(offset, length));
            this.trinoTimestampEncoder.write(decodedTimestamp, builder);
        }
        catch (DateTimeParseException dateTimeParseException) {
            builder.appendNull();
        }
    }
}

