/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line.csv;

import io.trino.hive.formats.line.Column;
import io.trino.hive.formats.line.LineSerializer;
import io.trino.hive.formats.line.LineSerializerFactory;
import io.trino.hive.formats.line.csv.CsvConstants;
import io.trino.hive.formats.line.csv.CsvSerializer;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CsvSerializerFactory
implements LineSerializerFactory {
    @Override
    public Set<String> getHiveSerDeClassNames() {
        return CsvConstants.HIVE_SERDE_CLASS_NAMES;
    }

    @Override
    public LineSerializer create(List<Column> columns, Map<String, String> serdeProperties) {
        byte separatorChar = CsvConstants.getByteProperty(serdeProperties, "separatorChar", (byte)44);
        byte quoteChar = CsvConstants.getByteProperty(serdeProperties, "quoteChar", (byte)34);
        byte escapeChar = CsvConstants.getByteProperty(serdeProperties, "escapeChar", (byte)34);
        return new CsvSerializer(columns, separatorChar, quoteChar, escapeChar);
    }
}

