/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.trino.hive.formats.line.json;

import com.google.common.collect.ImmutableSet;

import java.util.Set;

import static io.trino.hive.formats.HiveClassNames.JSON_SERDE_CLASS;
import static io.trino.hive.formats.HiveClassNames.LEGACY_JSON_SERDE_CLASS;

public final class JsonConstants
{
    static final Set<String> HIVE_SERDE_CLASS_NAMES = ImmutableSet.of(JSON_SERDE_CLASS, LEGACY_JSON_SERDE_CLASS);

    private JsonConstants() {}
}
