/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.avro.model;

import com.google.common.base.Verify;
import io.trino.hive.formats.avro.model.AvroReadAction;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;

public final class DoubleRead
implements AvroReadAction {
    private final Schema readSchema;
    private final Schema writeSchema;
    private final AvroReadAction.DoubleIoFunction<Decoder> doubleDecoder;

    DoubleRead(Schema readSchema, Schema writeSchema) {
        this.readSchema = Objects.requireNonNull(readSchema, "readSchema is null");
        this.writeSchema = Objects.requireNonNull(writeSchema, "writeSchema is null");
        Verify.verify((readSchema.getType() == Schema.Type.DOUBLE ? 1 : 0) != 0);
        this.doubleDecoder = AvroReadAction.getDoubleDecoderFunction(writeSchema);
    }

    @Override
    public Schema readSchema() {
        return this.readSchema;
    }

    @Override
    public Schema writeSchema() {
        return this.writeSchema;
    }

    public AvroReadAction.DoubleIoFunction<Decoder> getDoubleDecoder() {
        return this.doubleDecoder;
    }
}

