/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.compression;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.compress.v3.bzip2.BZip2HadoopStreams;
import io.airlift.compress.v3.deflate.JdkDeflateHadoopStreams;
import io.airlift.compress.v3.gzip.JdkGzipHadoopStreams;
import io.airlift.compress.v3.hadoop.HadoopStreams;
import io.airlift.compress.v3.lz4.Lz4HadoopStreams;
import io.airlift.compress.v3.lzo.LzoHadoopStreams;
import io.airlift.compress.v3.lzo.LzopHadoopStreams;
import io.airlift.compress.v3.snappy.SnappyHadoopStreams;
import io.airlift.compress.v3.zstd.ZstdHadoopStreams;
import io.trino.hive.formats.compression.Codec;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public enum CompressionKind {
    ZSTD((HadoopStreams)new ZstdHadoopStreams()),
    LZ4((HadoopStreams)new Lz4HadoopStreams()),
    SNAPPY((HadoopStreams)new SnappyHadoopStreams()),
    GZIP((HadoopStreams)new JdkGzipHadoopStreams()),
    DEFLATE((HadoopStreams)new JdkDeflateHadoopStreams()),
    BZIP2((HadoopStreams)new BZip2HadoopStreams()),
    LZO((HadoopStreams)new LzoHadoopStreams()),
    LZOP((HadoopStreams)new LzopHadoopStreams());

    private final HadoopStreams hadoopStreams;
    private final List<String> hadoopClassNames;
    private final String fileExtension;
    private static final Map<String, CompressionKind> CODECS_BY_HADOOP_CLASS_NAME;
    private static final Map<String, CompressionKind> CODECS_BY_FILE_EXTENSION;

    private CompressionKind(HadoopStreams hadoopStreams) {
        this.hadoopStreams = Objects.requireNonNull(hadoopStreams, "hadoopStreams is null");
        this.hadoopClassNames = ImmutableList.copyOf((Collection)hadoopStreams.getHadoopCodecName());
        this.fileExtension = hadoopStreams.getDefaultFileExtension();
    }

    public String getHadoopClassName() {
        return this.hadoopClassNames.get(0);
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public Codec createCodec() {
        return new Codec(this.hadoopStreams);
    }

    public static CompressionKind fromHadoopClassName(String hadoopClassName) {
        return Optional.ofNullable(CODECS_BY_HADOOP_CLASS_NAME.get(hadoopClassName)).orElseThrow(() -> new IllegalArgumentException("Unknown codec: " + hadoopClassName));
    }

    public static Optional<CompressionKind> forFile(String fileName) {
        int position = fileName.lastIndexOf(46);
        if (position < 0) {
            return Optional.empty();
        }
        return Optional.ofNullable(CODECS_BY_FILE_EXTENSION.get(fileName.substring(position)));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (CompressionKind codec2 : CompressionKind.values()) {
            for (String hadoopClassNames : codec2.hadoopClassNames) {
                builder.put((Object)hadoopClassNames, (Object)codec2);
            }
        }
        CODECS_BY_HADOOP_CLASS_NAME = builder.buildOrThrow();
        CODECS_BY_FILE_EXTENSION = (Map)Arrays.stream(CompressionKind.values()).filter(codec -> codec.fileExtension != null).collect(ImmutableMap.toImmutableMap(codec -> codec.fileExtension, Function.identity()));
    }
}

