/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.hive.formats.HiveFormatUtils;
import io.trino.hive.formats.line.Column;
import io.trino.hive.formats.line.LineSerializer;
import io.trino.plugin.base.util.JsonUtils;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.SqlMap;
import io.trino.spi.block.SqlRow;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class JsonSerializer
implements LineSerializer {
    private final RowType type;
    private final JsonFactory jsonFactory;
    private final FieldWriter[] fieldWriters;

    public JsonSerializer(List<Column> columns) {
        this.type = RowType.from((List)((List)columns.stream().map(column -> RowType.field((String)column.name().toLowerCase(Locale.ROOT), (Type)column.type())).collect(ImmutableList.toImmutableList())));
        this.fieldWriters = JsonSerializer.createRowTypeFieldWriters(this.type);
        this.jsonFactory = JsonUtils.jsonFactory();
    }

    @Override
    public List<? extends Type> getTypes() {
        return this.type.getTypeParameters();
    }

    @Override
    public void write(Page page, int position, SliceOutput sliceOutput) throws IOException {
        try (JsonGenerator generator = this.jsonFactory.createGenerator((OutputStream)sliceOutput);){
            generator.writeStartObject();
            for (int field = 0; field < this.fieldWriters.length; ++field) {
                this.fieldWriters[field].writeField(generator, page.getBlock(field), position);
            }
            generator.writeEndObject();
        }
    }

    private static ValueWriter createValueWriter(Type type) {
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return (generator, block, position) -> generator.writeBoolean(BooleanType.BOOLEAN.getBoolean(block, position));
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return (generator, block, position) -> generator.writeNumber(BigintType.BIGINT.getLong(block, position));
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return (generator, block, position) -> generator.writeNumber(IntegerType.INTEGER.getInt(block, position));
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return (generator, block, position) -> generator.writeNumber(SmallintType.SMALLINT.getShort(block, position));
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return (generator, block, position) -> generator.writeNumber((short)TinyintType.TINYINT.getByte(block, position));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return (generator, block, position) -> {
                SqlDecimal value = (SqlDecimal)decimalType.getObjectValue(null, block, position);
                generator.writeNumber(value.toBigDecimal().toString());
            };
        }
        if (RealType.REAL.equals((Object)type)) {
            return (generator, block, position) -> generator.writeNumber(RealType.REAL.getFloat(block, position));
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return (generator, block, position) -> generator.writeNumber(DoubleType.DOUBLE.getDouble(block, position));
        }
        if (DateType.DATE.equals((Object)type)) {
            return (generator, block, position) -> generator.writeString(HiveFormatUtils.formatHiveDate(block, position));
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            return (generator, block, position) -> generator.writeString(HiveFormatUtils.formatHiveTimestamp((Type)timestampType, block, position));
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return (generator, block, position) -> {
                String value = VarbinaryType.VARBINARY.getSlice(block, position).toStringUtf8();
                generator.writeString(value);
            };
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            return (generator, block, position) -> generator.writeString(varcharType.getSlice(block, position).toStringUtf8());
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            return (generator, block, position) -> generator.writeString(Chars.padSpaces((Slice)charType.getSlice(block, position), (CharType)charType).toStringUtf8());
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return new ArrayValueWriter(arrayType, JsonSerializer.createValueWriter(arrayType.getElementType()));
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            return new MapValueWriter(mapType, JsonSerializer.createMapKeyFunction(mapType.getKeyType()), JsonSerializer.createValueWriter(mapType.getValueType()));
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            return new RowValueWriter(rowType, JsonSerializer.createRowTypeFieldWriters(rowType));
        }
        throw new UnsupportedOperationException("Unsupported column type: " + String.valueOf(type));
    }

    private static FieldWriter[] createRowTypeFieldWriters(RowType rowType) {
        List fields = rowType.getFields();
        FieldWriter[] writers = new FieldWriter[fields.size()];
        int index = 0;
        for (RowType.Field field : fields) {
            writers[index++] = new FieldWriter(new SerializedString((String)field.getName().orElseThrow()), JsonSerializer.createValueWriter(field.getType()));
        }
        return writers;
    }

    private static ToMapKeyFunction createMapKeyFunction(Type type) {
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return (block, position) -> String.valueOf(BooleanType.BOOLEAN.getBoolean(block, position));
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return (block, position) -> String.valueOf(BigintType.BIGINT.getLong(block, position));
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return (block, position) -> String.valueOf(IntegerType.INTEGER.getInt(block, position));
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return (block, position) -> String.valueOf(SmallintType.SMALLINT.getShort(block, position));
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return (block, position) -> String.valueOf(TinyintType.TINYINT.getByte(block, position));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return (block, position) -> decimalType.getObjectValue(null, block, position).toString();
        }
        if (RealType.REAL.equals((Object)type)) {
            return (block, position) -> String.valueOf(RealType.REAL.getFloat(block, position));
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return (block, position) -> String.valueOf(DoubleType.DOUBLE.getDouble(block, position));
        }
        if (DateType.DATE.equals((Object)type)) {
            return HiveFormatUtils::formatHiveDate;
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            return (block, position) -> HiveFormatUtils.formatHiveTimestamp((Type)timestampType, block, position);
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return (block, position) -> VarbinaryType.VARBINARY.getSlice(block, position).toStringUtf8();
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            return (block, position) -> varcharType.getSlice(block, position).toStringUtf8();
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            return (block, position) -> Chars.padSpaces((Slice)charType.getSlice(block, position), (CharType)charType).toStringUtf8();
        }
        throw new UnsupportedOperationException("Unsupported map key type: " + String.valueOf(type));
    }

    private record FieldWriter(SerializedString fieldName, ValueWriter valueWriter) {
        public void writeField(JsonGenerator generator, Block block, int position) throws IOException {
            generator.writeFieldName((SerializableString)this.fieldName);
            this.valueWriter.writeValue(generator, block, position);
        }
    }

    private static interface ValueWriter {
        default public void writeValue(JsonGenerator generator, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                generator.writeNull();
            } else {
                this.writeNonNull(generator, block, position);
            }
        }

        public void writeNonNull(JsonGenerator var1, Block var2, int var3) throws IOException;
    }

    private record ArrayValueWriter(ArrayType arrayType, ValueWriter elementWriter) implements ValueWriter
    {
        @Override
        public void writeNonNull(JsonGenerator generator, Block block, int position) throws IOException {
            Block arrayBlock = Objects.requireNonNull(this.arrayType.getObject(block, position));
            generator.writeStartArray();
            for (int arrayIndex = 0; arrayIndex < arrayBlock.getPositionCount(); ++arrayIndex) {
                this.elementWriter.writeValue(generator, arrayBlock, arrayIndex);
            }
            generator.writeEndArray();
        }
    }

    private record MapValueWriter(MapType mapType, ToMapKeyFunction toMapKey, ValueWriter valueWriter) implements ValueWriter
    {
        @Override
        public void writeNonNull(JsonGenerator generator, Block block, int position) throws IOException {
            SqlMap sqlMap = Objects.requireNonNull(this.mapType.getObject(block, position));
            int rawOffset = sqlMap.getRawOffset();
            Block rawKeyBlock = sqlMap.getRawKeyBlock();
            Block rawValueBlock = sqlMap.getRawValueBlock();
            generator.writeStartObject();
            for (int i = 0; i < sqlMap.getSize(); ++i) {
                Preconditions.checkArgument((!rawKeyBlock.isNull(rawOffset + i) ? 1 : 0) != 0, (Object)"map key is null");
                generator.writeFieldName(this.toMapKey.apply(rawKeyBlock, rawOffset + i));
                this.valueWriter.writeValue(generator, rawValueBlock, rawOffset + i);
            }
            generator.writeEndObject();
        }
    }

    private static interface ToMapKeyFunction {
        public String apply(Block var1, int var2);
    }

    private record RowValueWriter(RowType rowType, FieldWriter[] fieldWriters) implements ValueWriter
    {
        @Override
        public void writeNonNull(JsonGenerator generator, Block block, int position) throws IOException {
            SqlRow sqlRow = this.rowType.getObject(block, position);
            int rawIndex = sqlRow.getRawIndex();
            generator.writeStartObject();
            for (int field = 0; field < this.fieldWriters.length; ++field) {
                FieldWriter writer = this.fieldWriters[field];
                Block fieldBlock = sqlRow.getRawFieldBlock(field);
                writer.writeField(generator, fieldBlock, rawIndex);
            }
            generator.writeEndObject();
        }
    }
}

