/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.avro;

import io.airlift.slice.Slice;
import io.trino.hive.formats.avro.AvroTypeException;
import io.trino.hive.formats.avro.NativeLogicalTypesAvroTypeManager;
import io.trino.hive.formats.avro.model.AvroLogicalType;
import io.trino.spi.block.Block;
import io.trino.spi.type.CharType;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.function.BiFunction;
import org.apache.avro.Schema;
import org.joda.time.DateTimeZone;

public class HiveAvroTypeManager
extends NativeLogicalTypesAvroTypeManager {
    @Override
    public Optional<BiFunction<Block, Integer, Object>> overrideBlockToAvroObject(Schema schema, Type type) throws AvroTypeException {
        NativeLogicalTypesAvroTypeManager.ValidateLogicalTypeResult result;
        NativeLogicalTypesAvroTypeManager.ValidateLogicalTypeResult validateLogicalTypeResult = result = HiveAvroTypeManager.validateLogicalType(schema);
        Objects.requireNonNull(validateLogicalTypeResult);
        NativeLogicalTypesAvroTypeManager.ValidateLogicalTypeResult validateLogicalTypeResult2 = validateLogicalTypeResult;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NativeLogicalTypesAvroTypeManager.NoLogicalType.class, NativeLogicalTypesAvroTypeManager.NonNativeAvroLogicalType.class, NativeLogicalTypesAvroTypeManager.InvalidNativeAvroLogicalType.class, NativeLogicalTypesAvroTypeManager.ValidNativeAvroLogicalType.class}, (NativeLogicalTypesAvroTypeManager.ValidateLogicalTypeResult)validateLogicalTypeResult2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                NativeLogicalTypesAvroTypeManager.NoLogicalType ignored = (NativeLogicalTypesAvroTypeManager.NoLogicalType)validateLogicalTypeResult2;
                yield Optional.empty();
            }
            case 1 -> {
                NativeLogicalTypesAvroTypeManager.NonNativeAvroLogicalType nonNativeAvroLogicalType = (NativeLogicalTypesAvroTypeManager.NonNativeAvroLogicalType)validateLogicalTypeResult2;
                switch (nonNativeAvroLogicalType.getLogicalTypeName()) {
                    case "varchar": 
                    case "char": {
                        Type expectedType = HiveAvroTypeManager.getHiveLogicalVarCharOrCharType(schema, nonNativeAvroLogicalType);
                        if (!expectedType.equals((Object)type)) {
                            throw new AvroTypeException("Type provided for column [%s] is incompatible with type for schema: %s".formatted(type, expectedType));
                        }
                        yield Optional.of((block, pos) -> ((Slice)expectedType.getObject(block, pos.intValue())).toStringUtf8());
                    }
                }
                yield Optional.empty();
            }
            case 2 -> {
                NativeLogicalTypesAvroTypeManager.InvalidNativeAvroLogicalType invalidNativeAvroLogicalType = (NativeLogicalTypesAvroTypeManager.InvalidNativeAvroLogicalType)validateLogicalTypeResult2;
                switch (invalidNativeAvroLogicalType.getLogicalTypeName()) {
                    case "timestamp-millis": 
                    case "date": 
                    case "decimal": {
                        throw invalidNativeAvroLogicalType.getCause();
                    }
                }
                yield Optional.empty();
            }
            case 3 -> {
                NativeLogicalTypesAvroTypeManager.ValidNativeAvroLogicalType validNativeAvroLogicalType = (NativeLogicalTypesAvroTypeManager.ValidNativeAvroLogicalType)validateLogicalTypeResult2;
                AvroLogicalType v2 = validNativeAvroLogicalType.getLogicalType();
                Objects.requireNonNull(v2);
                AvroLogicalType var13_16 = v2;
                int var14_17 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AvroLogicalType.TimestampMillisLogicalType.class, AvroLogicalType.DateLogicalType.class, AvroLogicalType.BytesDecimalLogicalType.class}, (AvroLogicalType)var13_16, var14_17)) {
                    case 0: {
                        AvroLogicalType.TimestampMillisLogicalType __ = (AvroLogicalType.TimestampMillisLogicalType)var13_16;
                        if (!(type instanceof TimestampType)) {
                            throw new AvroTypeException("Can't represent avro logical type %s with Trino Type %s".formatted(validNativeAvroLogicalType.getLogicalType(), type));
                        }
                        TimestampType timestampType = (TimestampType)type;
                        if (timestampType.isShort()) {
                            yield Optional.of((block, pos) -> {
                                long millis = Timestamps.roundDiv((long)timestampType.getLong(block, pos.intValue()), (long)1000L);
                                return DateTimeZone.forTimeZone((TimeZone)TimeZone.getDefault()).convertLocalToUTC(millis, false);
                            });
                        }
                        yield Optional.of((block, pos) -> {
                            SqlTimestamp timestamp = (SqlTimestamp)timestampType.getObject(block, pos.intValue());
                            return DateTimeZone.forTimeZone((TimeZone)TimeZone.getDefault()).convertLocalToUTC(timestamp.getMillis(), false);
                        });
                    }
                    case 1: {
                        AvroLogicalType.DateLogicalType __ = (AvroLogicalType.DateLogicalType)var13_16;
                        yield super.overrideBlockToAvroObject(schema, type);
                    }
                    case 2: {
                        AvroLogicalType.BytesDecimalLogicalType __ = (AvroLogicalType.BytesDecimalLogicalType)var13_16;
                        yield super.overrideBlockToAvroObject(schema, type);
                    }
                }
                yield Optional.empty();
            }
        };
    }

    static Type getHiveLogicalVarCharOrCharType(Schema schema, NativeLogicalTypesAvroTypeManager.NonNativeAvroLogicalType nonNativeAvroLogicalType) throws AvroTypeException {
        if (schema.getType() != Schema.Type.STRING) {
            throw new AvroTypeException("Unsupported Avro type for Hive Logical Type in schema " + String.valueOf(schema));
        }
        Object maxLengthObject = schema.getObjectProp("maxLength");
        if (maxLengthObject == null) {
            throw new AvroTypeException("Missing property maxLength in schema for Hive Type " + nonNativeAvroLogicalType.getLogicalTypeName());
        }
        try {
            int maxLength;
            if (maxLengthObject instanceof String) {
                String maxLengthString = (String)maxLengthObject;
                maxLength = Integer.parseInt(maxLengthString);
            } else if (maxLengthObject instanceof Number) {
                Number maxLengthNumber = (Number)maxLengthObject;
                maxLength = maxLengthNumber.intValue();
            } else {
                throw new AvroTypeException("Unrecognized property type for maxLength in schema " + String.valueOf(schema));
            }
            if (nonNativeAvroLogicalType.getLogicalTypeName().equals("varchar")) {
                return VarcharType.createVarcharType((int)maxLength);
            }
            return CharType.createCharType((int)maxLength);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AvroTypeException("Property maxLength not convertible to Integer in Hive Logical type schema " + String.valueOf(schema));
        }
    }
}

