/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line.csv;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;

public final class CsvConstants {
    static final Set<String> HIVE_SERDE_CLASS_NAMES = ImmutableSet.of((Object)"org.apache.hadoop.hive.serde2.OpenCSVSerde");
    static final String SEPARATOR_KEY = "separatorChar";
    static final String QUOTE_KEY = "quoteChar";
    static final String ESCAPE_KEY = "escapeChar";
    static final byte DEFAULT_SEPARATOR = 44;
    static final byte DEFAULT_QUOTE = 34;
    static final byte DESERIALIZER_DEFAULT_ESCAPE = 92;
    static final byte SERIALIZER_DEFAULT_ESCAPE = 34;

    private CsvConstants() {
    }

    static char getCharProperty(Map<String, String> schema, String key, byte defaultValue) {
        String value = schema.get(key);
        if (value == null) {
            return (char)defaultValue;
        }
        return value.charAt(0);
    }

    static byte getByteProperty(Map<String, String> schema, String key, byte defaultValue) {
        char c = CsvConstants.getCharProperty(schema, key, defaultValue);
        if (c > '\u007f') {
            throw new IllegalArgumentException("%s must be 7-bit ASCII: %02x".formatted(key, (short)c));
        }
        return (byte)c;
    }
}

