/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.encodings.binary;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.hive.formats.ReadWriteUtils;
import io.trino.hive.formats.encodings.ColumnData;
import io.trino.hive.formats.encodings.EncodeOutput;
import io.trino.hive.formats.encodings.binary.BinaryColumnEncoding;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;

public class StringEncoding
implements BinaryColumnEncoding {
    private static final byte HIVE_EMPTY_STRING_BYTE = -65;
    private final Type type;

    public StringEncoding(Type type) {
        this.type = type;
    }

    @Override
    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (!block.isNull(position)) {
                Slice slice = this.type.getSlice(block, position);
                if (slice.length() == 0) {
                    output.writeByte(-65);
                } else {
                    output.writeBytes(slice);
                }
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public void encodeValueInto(Block block, int position, SliceOutput output) {
        Slice slice = this.type.getSlice(block, position);
        ReadWriteUtils.writeVInt(output, slice.length());
        output.writeBytes(slice);
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int length = columnData.getLength(i);
            if (length > 0) {
                int offset = columnData.getOffset(i);
                if (length == 1 && slice.getByte(offset) == -65) {
                    this.type.writeSlice(builder, Slices.EMPTY_SLICE);
                    continue;
                }
                length = ReadWriteUtils.calculateTruncationLength(this.type, slice, offset, length);
                this.type.writeSlice(builder, slice.slice(offset, length));
                continue;
            }
            builder.appendNull();
        }
        return builder.build();
    }

    @Override
    public int getValueOffset(Slice slice, int offset) {
        return ReadWriteUtils.decodeVIntSize(slice, offset);
    }

    @Override
    public int getValueLength(Slice slice, int offset) {
        return Math.toIntExact(ReadWriteUtils.readVInt(slice, offset));
    }

    @Override
    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) {
        length = ReadWriteUtils.calculateTruncationLength(this.type, slice, offset, length);
        this.type.writeSlice(builder, slice, offset, length);
    }
}

