/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.avro;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreCollectors;
import io.trino.hive.formats.avro.AvroTypeException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.avro.Schema;

public final class AvroTypeUtils {
    private AvroTypeUtils() {
    }

    public static void verifyNoCircularReferences(Schema schema) throws AvroTypeException {
        AvroTypeUtils.verifyNoCircularReferences(schema, new HashSet<Schema>());
    }

    private static void verifyNoCircularReferences(Schema schema, Set<Schema> enclosingRecords) throws AvroTypeException {
        switch (schema.getType()) {
            case NULL: 
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case ENUM: 
            case STRING: 
            case FIXED: 
            case BYTES: {
                break;
            }
            case ARRAY: {
                AvroTypeUtils.verifyNoCircularReferences(schema.getElementType(), enclosingRecords);
                break;
            }
            case MAP: {
                AvroTypeUtils.verifyNoCircularReferences(schema.getValueType(), enclosingRecords);
                break;
            }
            case RECORD: {
                if (!enclosingRecords.add(schema)) {
                    throw new AvroTypeException("Recursive Avro Schema not supported: " + schema.getFullName());
                }
                for (Schema.Field field : schema.getFields()) {
                    AvroTypeUtils.verifyNoCircularReferences(field.schema(), new HashSet<Schema>(enclosingRecords));
                }
                break;
            }
            case UNION: {
                for (Schema schemaOption : schema.getTypes()) {
                    AvroTypeUtils.verifyNoCircularReferences(schemaOption, enclosingRecords);
                }
                break;
            }
        }
    }

    public static boolean isSimpleNullableUnion(Schema schema) {
        Verify.verify((boolean)schema.isUnion(), (String)"Schema must be union", (Object[])new Object[0]);
        return schema.getTypes().stream().filter(Predicate.not(Schema::isNullable)).count() == 1L;
    }

    static Schema unwrapNullableUnion(Schema schema) {
        Verify.verify((boolean)schema.isUnion(), (String)"Schema must be union", (Object[])new Object[0]);
        Verify.verify((schema.isNullable() && schema.getTypes().size() == 2 ? 1 : 0) != 0);
        return (Schema)schema.getTypes().stream().filter(Predicate.not(Schema::isNullable)).collect(MoreCollectors.onlyElement());
    }

    public static SimpleUnionNullIndex getSimpleNullableUnionNullIndex(Schema schema) {
        Verify.verify((boolean)schema.isUnion(), (String)"Schema must be union", (Object[])new Object[0]);
        Verify.verify((schema.isNullable() && schema.getTypes().size() == 2 ? 1 : 0) != 0, (String)"Invalid null union: %s", (Object)schema);
        return ((Schema)schema.getTypes().get(0)).getType() == Schema.Type.NULL ? SimpleUnionNullIndex.ZERO : SimpleUnionNullIndex.ONE;
    }

    static Schema lowerCaseAllFieldsForWriter(Schema schema) {
        return switch (schema.getType()) {
            default -> throw new MatchException(null, null);
            case Schema.Type.RECORD -> Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError(), (List)((List)schema.getFields().stream().map(field -> new Schema.Field(field.name().toLowerCase(Locale.ENGLISH), AvroTypeUtils.lowerCaseAllFieldsForWriter(field.schema()), field.doc())).collect(ImmutableList.toImmutableList())));
            case Schema.Type.ARRAY -> Schema.createArray((Schema)AvroTypeUtils.lowerCaseAllFieldsForWriter(schema.getElementType()));
            case Schema.Type.MAP -> Schema.createMap((Schema)AvroTypeUtils.lowerCaseAllFieldsForWriter(schema.getValueType()));
            case Schema.Type.UNION -> Schema.createUnion((List)((List)schema.getTypes().stream().map(AvroTypeUtils::lowerCaseAllFieldsForWriter).collect(ImmutableList.toImmutableList())));
            case Schema.Type.NULL, Schema.Type.BOOLEAN, Schema.Type.INT, Schema.Type.LONG, Schema.Type.FLOAT, Schema.Type.DOUBLE, Schema.Type.ENUM, Schema.Type.STRING, Schema.Type.FIXED, Schema.Type.BYTES -> schema;
        };
    }

    static enum SimpleUnionNullIndex {
        ZERO(0),
        ONE(1);

        private final int index;

        private SimpleUnionNullIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

