/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.avro.model;

import io.trino.hive.formats.avro.model.RecordFieldReadAction;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;

public record SkipFieldRecordFieldReadAction(SkipAction skipAction) implements RecordFieldReadAction
{
    public SkipFieldRecordFieldReadAction {
        Objects.requireNonNull(skipAction, "skipAction is null");
    }

    public static SkipAction createSkipActionForSchema(Schema schema) {
        return switch (schema.getType()) {
            default -> throw new MatchException(null, null);
            case Schema.Type.NULL -> Decoder::readNull;
            case Schema.Type.BOOLEAN -> Decoder::readBoolean;
            case Schema.Type.INT -> Decoder::readInt;
            case Schema.Type.LONG -> Decoder::readLong;
            case Schema.Type.FLOAT -> Decoder::readFloat;
            case Schema.Type.DOUBLE -> Decoder::readDouble;
            case Schema.Type.STRING -> Decoder::skipString;
            case Schema.Type.BYTES -> Decoder::skipBytes;
            case Schema.Type.ENUM -> Decoder::readEnum;
            case Schema.Type.FIXED -> {
                int size = schema.getFixedSize();
                yield decoder -> decoder.skipFixed(size);
            }
            case Schema.Type.ARRAY -> new ArraySkipAction(schema.getElementType());
            case Schema.Type.MAP -> new MapSkipAction(schema.getValueType());
            case Schema.Type.RECORD -> new RecordSkipAction(schema.getFields());
            case Schema.Type.UNION -> new UnionSkipAction(schema.getTypes());
        };
    }

    @FunctionalInterface
    public static interface SkipAction {
        public void skip(Decoder var1) throws IOException;
    }

    private static class ArraySkipAction
    implements SkipAction {
        private final SkipAction elementSkipAction;

        public ArraySkipAction(Schema elementSchema) {
            this.elementSkipAction = SkipFieldRecordFieldReadAction.createSkipActionForSchema(Objects.requireNonNull(elementSchema, "elementSchema is null"));
        }

        @Override
        public void skip(Decoder decoder) throws IOException {
            long i = decoder.skipArray();
            while (i != 0L) {
                for (long j = 0L; j < i; ++j) {
                    this.elementSkipAction.skip(decoder);
                }
                i = decoder.skipArray();
            }
        }
    }

    private static class MapSkipAction
    implements SkipAction {
        private final SkipAction valueSkipAction;

        public MapSkipAction(Schema valueSchema) {
            this.valueSkipAction = SkipFieldRecordFieldReadAction.createSkipActionForSchema(Objects.requireNonNull(valueSchema, "valueSchema is null"));
        }

        @Override
        public void skip(Decoder decoder) throws IOException {
            long i = decoder.skipMap();
            while (i != 0L) {
                for (long j = 0L; j < i; ++j) {
                    decoder.skipString();
                    this.valueSkipAction.skip(decoder);
                }
                i = decoder.skipMap();
            }
        }
    }

    private static class RecordSkipAction
    implements SkipAction {
        private final SkipAction[] fieldSkips;

        public RecordSkipAction(List<Schema.Field> fields) {
            this.fieldSkips = new SkipAction[Objects.requireNonNull(fields, "fields is null").size()];
            for (int i = 0; i < fields.size(); ++i) {
                this.fieldSkips[i] = SkipFieldRecordFieldReadAction.createSkipActionForSchema(fields.get(i).schema());
            }
        }

        @Override
        public void skip(Decoder decoder) throws IOException {
            for (SkipAction fieldSkipAction : this.fieldSkips) {
                fieldSkipAction.skip(decoder);
            }
        }
    }

    private static class UnionSkipAction
    implements SkipAction {
        private final SkipAction[] skipActions;

        private UnionSkipAction(List<Schema> types) {
            this.skipActions = new SkipAction[Objects.requireNonNull(types, "types is null").size()];
            for (int i = 0; i < types.size(); ++i) {
                this.skipActions[i] = SkipFieldRecordFieldReadAction.createSkipActionForSchema(types.get(i));
            }
        }

        @Override
        public void skip(Decoder decoder) throws IOException {
            this.skipActions[decoder.readIndex()].skip(decoder);
        }
    }
}

