/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.encodings.binary;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.hive.formats.ReadWriteUtils;
import io.trino.hive.formats.encodings.binary.BinaryColumnEncoding;
import io.trino.hive.formats.encodings.binary.BlockEncoding;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;

public class ListEncoding
extends BlockEncoding {
    private final ArrayType arrayType;
    private final BinaryColumnEncoding elementEncoding;

    public ListEncoding(ArrayType arrayType, BinaryColumnEncoding elementEncoding) {
        super((Type)arrayType);
        this.arrayType = arrayType;
        this.elementEncoding = elementEncoding;
    }

    @Override
    public void encodeValue(Block block, int position, SliceOutput output) {
        int elementIndex;
        Block list = this.arrayType.getObject(block, position);
        ReadWriteUtils.writeVInt(output, list.getPositionCount());
        int nullByte = 0;
        for (elementIndex = 0; elementIndex < list.getPositionCount(); ++elementIndex) {
            if (elementIndex != 0 && elementIndex % 8 == 0) {
                output.writeByte(nullByte);
                nullByte = 0;
            }
            if (list.isNull(elementIndex)) continue;
            nullByte |= 1 << elementIndex % 8;
        }
        output.writeByte(nullByte);
        for (elementIndex = 0; elementIndex < list.getPositionCount(); ++elementIndex) {
            if (list.isNull(elementIndex)) continue;
            this.elementEncoding.encodeValueInto(list, elementIndex, output);
        }
    }

    @Override
    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) {
        ((ArrayBlockBuilder)builder).buildEntry(elementBuilder -> this.decodeArrayInto(elementBuilder, slice, offset));
    }

    private void decodeArrayInto(BlockBuilder elementBuilder, Slice slice, int offset) {
        int nullByteEnd;
        int entries = Math.toIntExact(ReadWriteUtils.readVInt(slice, offset));
        offset += ReadWriteUtils.decodeVIntSize(slice.getByte(offset));
        int nullByteCur = offset;
        int elementOffset = nullByteEnd = offset + (entries + 7) / 8;
        for (int i = 0; i < entries; ++i) {
            if ((slice.getByte(nullByteCur) & 1 << i % 8) != 0) {
                int valueOffset = this.elementEncoding.getValueOffset(slice, elementOffset);
                int valueLength = this.elementEncoding.getValueLength(slice, elementOffset);
                this.elementEncoding.decodeValueInto(elementBuilder, slice, elementOffset + valueOffset, valueLength);
                elementOffset = elementOffset + valueOffset + valueLength;
            } else {
                elementBuilder.appendNull();
            }
            if (7 != i % 8) continue;
            ++nullByteCur;
        }
    }
}

