/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats;

import com.google.common.collect.ImmutableList;
import io.trino.hive.formats.HiveFormatsErrorCode;
import io.trino.plugin.base.type.DecodedTimestamp;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalConversions;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.Int128;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadWritableInstant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;

public final class HiveFormatUtils {
    public static final String TIMESTAMP_FORMATS_KEY = "timestamp.formats";
    private static final char TIMESTAMP_FORMATS_SEPARATOR = ',';
    private static final char TIMESTAMP_FORMATS_ESCAPE = '\\';
    private static final java.time.format.DateTimeFormatter DATE_PARSER = new java.time.format.DateTimeFormatterBuilder().parseLenient().appendValue(ChronoField.YEAR, 1, 10, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NORMAL).toFormatter().withResolverStyle(ResolverStyle.LENIENT);
    private static final java.time.format.DateTimeFormatter DATE_FORMATTER = new java.time.format.DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 1, 10, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2, 2, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2, 2, SignStyle.NORMAL).toFormatter();
    private static final java.time.format.DateTimeFormatter DEFAULT_TIMESTAMP_PARSER = new java.time.format.DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendValue(ChronoField.YEAR, 1, 10, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NORMAL).optionalStart().appendLiteral(" ").appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NORMAL).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NORMAL).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NORMAL).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, true).optionalEnd().optionalEnd().toFormatter().withResolverStyle(ResolverStyle.LENIENT);
    private static final java.time.format.DateTimeFormatter ISO_TIMESTAMP_PARSER = new java.time.format.DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().append(java.time.format.DateTimeFormatter.ISO_LOCAL_DATE_TIME).toFormatter().withResolverStyle(ResolverStyle.LENIENT);
    private static final java.time.format.DateTimeFormatter TIMESTAMP_FORMATTER = new java.time.format.DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 1, 10, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2, 2, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2, 2, SignStyle.NORMAL).optionalStart().appendLiteral(" ").appendValue(ChronoField.HOUR_OF_DAY, 2, 2, SignStyle.NORMAL).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2, 2, SignStyle.NORMAL).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NORMAL).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().optionalEnd().toFormatter();
    private static final String MILLIS_TIMESTAMP_FORMAT = "millis";
    private static final DateTime STARTING_TIMESTAMP_VALUE = new DateTime(1970, 1, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC());

    private HiveFormatUtils() {
    }

    public static LocalDate parseHiveDate(String value) {
        int index = (value = value.trim()).indexOf(" ");
        if (index != -1) {
            value = value.substring(0, index);
        }
        return LocalDate.parse(value, DATE_PARSER);
    }

    public static void writeDecimal(String value, DecimalType decimalType, BlockBuilder builder) {
        BigDecimal bigDecimal = HiveFormatUtils.parseDecimal(value, decimalType);
        if (Decimals.overflows((BigDecimal)bigDecimal, (long)decimalType.getPrecision())) {
            throw new NumberFormatException(String.format("Cannot convert '%s' to %s. Value too large.", value, decimalType));
        }
        if (decimalType.isShort()) {
            decimalType.writeLong(builder, bigDecimal.unscaledValue().longValueExact());
        } else {
            decimalType.writeObject(builder, (Object)Int128.valueOf((BigInteger)bigDecimal.unscaledValue()));
        }
    }

    public static BigDecimal parseDecimal(String value, DecimalType decimalType) {
        try {
            return HiveFormatUtils.scaleDecimal(new BigDecimal(value), decimalType);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.format("Cannot convert '%s' to %s. Value is not a number.", value, decimalType));
        }
    }

    public static BigDecimal scaleDecimal(BigDecimal bigDecimal, DecimalType decimalType) {
        return bigDecimal.setScale(DecimalConversions.intScale((long)decimalType.getScale()), RoundingMode.HALF_UP);
    }

    public static Function<String, DecodedTimestamp> createTimestampParser(List<String> timestampFormats) {
        Objects.requireNonNull(timestampFormats, "timestampFormats is null");
        if (timestampFormats.isEmpty()) {
            return value -> HiveFormatUtils.parseHiveTimestamp(null, value);
        }
        DateTimeParser[] parsers = new DateTimeParser[timestampFormats.size()];
        for (int i = 0; i < timestampFormats.size(); ++i) {
            String formatString = timestampFormats.get(i);
            parsers[i] = formatString.equalsIgnoreCase(MILLIS_TIMESTAMP_FORMAT) ? new MillisDateFormatParser() : DateTimeFormat.forPattern((String)formatString).getParser();
        }
        DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().append(null, parsers).toFormatter().withDefaultYear(1970);
        return value -> HiveFormatUtils.parseHiveTimestamp(dateTimeFormatter, value);
    }

    private static DecodedTimestamp parseHiveTimestamp(DateTimeFormatter dateTimeFormatter, String value) {
        value = value.trim();
        if (dateTimeFormatter != null) {
            try {
                MutableDateTime dateTime = new MutableDateTime((Object)STARTING_TIMESTAMP_VALUE, (Chronology)ISOChronology.getInstanceUTC());
                int parsedLength = dateTimeFormatter.parseInto((ReadWritableInstant)dateTime, value, 0);
                if (parsedLength == value.length()) {
                    long millis = dateTime.getMillis();
                    long epochSeconds = StrictMath.floorDiv(millis, 1000L);
                    long fractionalSecond = StrictMath.floorMod(millis, 1000L);
                    int nanosOfSecond = StrictMath.toIntExact(fractionalSecond * 1000000L);
                    return new DecodedTimestamp(epochSeconds, nanosOfSecond);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return HiveFormatUtils.parseTrimmedHiveTimestamp(value);
    }

    public static DecodedTimestamp parseHiveTimestamp(String value) {
        return HiveFormatUtils.parseTrimmedHiveTimestamp(value.trim());
    }

    private static DecodedTimestamp parseTrimmedHiveTimestamp(String value) {
        LocalDateTime localDateTime;
        try {
            localDateTime = LocalDateTime.parse(value, DEFAULT_TIMESTAMP_PARSER);
        }
        catch (DateTimeParseException e) {
            localDateTime = LocalDateTime.parse(value, ISO_TIMESTAMP_PARSER);
        }
        return new DecodedTimestamp(localDateTime.toEpochSecond(ZoneOffset.UTC), localDateTime.getNano());
    }

    public static List<String> getTimestampFormatsSchemaProperty(Map<String, String> serdeProperties) {
        String property = serdeProperties.get(TIMESTAMP_FORMATS_KEY);
        if (property == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        StringBuilder buffer = new StringBuilder();
        for (int position = 0; position < property.length(); ++position) {
            char c = property.charAt(position);
            if (c == '\\') {
                if (position + 1 >= property.length()) {
                    throw new TrinoException((ErrorCodeSupplier)HiveFormatsErrorCode.HIVE_INVALID_METADATA, "Invalid '%s' property value '%s': unterminated escape at end of value".formatted(TIMESTAMP_FORMATS_KEY, property));
                }
                char nextCharacter = property.charAt(position + 1);
                if (nextCharacter != ',' && nextCharacter != '\\') {
                    throw new TrinoException((ErrorCodeSupplier)HiveFormatsErrorCode.HIVE_INVALID_METADATA, "Invalid '%s' property value '%s': Illegal escaped character at %s".formatted(TIMESTAMP_FORMATS_KEY, property, position));
                }
                buffer.append(nextCharacter);
                ++position;
                continue;
            }
            if (c == ',') {
                if (buffer.isEmpty()) continue;
                result.add((Object)buffer.toString());
                buffer.setLength(0);
                continue;
            }
            buffer.append(c);
        }
        if (!buffer.isEmpty()) {
            result.add((Object)buffer.toString());
        }
        return result.build();
    }

    public static String formatHiveDate(Block block, int position) {
        LocalDate localDate = LocalDate.ofEpochDay(DateType.DATE.getInt(block, position));
        return localDate.format(DATE_FORMATTER);
    }

    public static void formatHiveDate(Block block, int position, StringBuilder builder) {
        LocalDate localDate = LocalDate.ofEpochDay(DateType.DATE.getInt(block, position));
        DATE_FORMATTER.formatTo(localDate, builder);
    }

    public static String formatHiveTimestamp(Type type, Block block, int position) {
        SqlTimestamp objectValue = (SqlTimestamp)type.getObjectValue(null, block, position);
        LocalDateTime localDateTime = objectValue.toLocalDateTime();
        return TIMESTAMP_FORMATTER.format(localDateTime);
    }

    public static void formatHiveTimestamp(Type type, Block block, int position, StringBuilder builder) {
        SqlTimestamp objectValue = (SqlTimestamp)type.getObjectValue(null, block, position);
        LocalDateTime localDateTime = objectValue.toLocalDateTime();
        TIMESTAMP_FORMATTER.formatTo(localDateTime, builder);
    }

    private static class MillisDateFormatParser
    implements DateTimeParser {
        private static final Pattern PATTERN = Pattern.compile("(-?\\d+)(\\.\\d+)?$");
        private static final DateTimeFieldType[] DATE_TIME_FIELDS = new DateTimeFieldType[]{DateTimeFieldType.year(), DateTimeFieldType.monthOfYear(), DateTimeFieldType.dayOfMonth(), DateTimeFieldType.hourOfDay(), DateTimeFieldType.minuteOfHour(), DateTimeFieldType.secondOfMinute(), DateTimeFieldType.millisOfSecond()};

        private MillisDateFormatParser() {
        }

        public int estimateParsedLength() {
            return 13;
        }

        public int parseInto(DateTimeParserBucket bucket, String text, int position) {
            Matcher matcher = PATTERN.matcher(text = text.substring(position));
            if (!matcher.matches()) {
                return -1;
            }
            long millis = Long.parseLong(matcher.group(1));
            DateTime dateTime = new DateTime(millis, (Chronology)ISOChronology.getInstanceUTC());
            for (DateTimeFieldType field : DATE_TIME_FIELDS) {
                bucket.saveField(field, dateTime.get(field));
            }
            return text.length();
        }
    }
}

