/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public final class LineBuffer
extends OutputStream {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(LineBuffer.class);
    private final int maxLength;
    private byte[] buffer;
    private int length;

    public LineBuffer(int initialBufferSize, int maxLength) {
        Preconditions.checkArgument((initialBufferSize > 0 ? 1 : 0) != 0, (Object)"initialBufferSize must be at least one byte");
        Preconditions.checkArgument((maxLength > 0 ? 1 : 0) != 0, (Object)"maxLength must be at least one byte");
        Preconditions.checkArgument((maxLength <= 0x40000000 ? 1 : 0) != 0, (Object)"maxLength is greater than 1GB");
        Preconditions.checkArgument((initialBufferSize <= maxLength ? 1 : 0) != 0, (Object)"initialBufferSize is greater than maxLength");
        this.maxLength = maxLength;
        this.buffer = new byte[initialBufferSize];
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public int getLength() {
        return this.length;
    }

    public void reset() {
        this.length = 0;
    }

    public long getRetainedSize() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.buffer);
    }

    @Override
    public void write(int b) throws IOException {
        this.growBufferIfNecessary(1);
        this.buffer[this.length] = (byte)b;
        ++this.length;
    }

    @Override
    public void write(byte[] source, int sourceOffset, int sourceLength) throws IOException {
        this.growBufferIfNecessary(sourceLength);
        System.arraycopy(source, sourceOffset, this.buffer, this.length, sourceLength);
        this.length += sourceLength;
    }

    public void write(InputStream input, int size) throws IOException {
        this.growBufferIfNecessary(size);
        if (input.readNBytes(this.buffer, this.length, size) != size) {
            throw new EOFException("Input is too small");
        }
        this.length += size;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    private void growBufferIfNecessary(int minFreeSpace) throws IOException {
        int newLength = this.length + minFreeSpace;
        if (newLength > this.maxLength) {
            throw new IOException("Max line length exceeded: " + newLength);
        }
        if (this.buffer.length < newLength) {
            int newSize = Math.clamp((long)this.buffer.length * 2L, newLength, this.maxLength);
            this.buffer = Arrays.copyOf(this.buffer, newSize);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("maxLength", this.maxLength).add("capacity", this.buffer.length).add("length", this.length).toString();
    }
}

