/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.avro;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.hive.formats.UnionToRowCoercionUtils;
import io.trino.hive.formats.avro.AvroTypeBlockHandler;
import io.trino.hive.formats.avro.AvroTypeException;
import io.trino.hive.formats.avro.AvroTypeUtils;
import io.trino.hive.formats.avro.BaseAvroTypeBlockHandlerImpls;
import io.trino.hive.formats.avro.BlockBuildingDecoder;
import io.trino.hive.formats.avro.HiveAvroTypeManager;
import io.trino.hive.formats.avro.NativeLogicalTypesAvroTypeBlockHandler;
import io.trino.hive.formats.avro.NativeLogicalTypesAvroTypeManager;
import io.trino.hive.formats.avro.model.ArrayReadAction;
import io.trino.hive.formats.avro.model.AvroLogicalType;
import io.trino.hive.formats.avro.model.AvroReadAction;
import io.trino.hive.formats.avro.model.BooleanRead;
import io.trino.hive.formats.avro.model.BytesRead;
import io.trino.hive.formats.avro.model.DoubleRead;
import io.trino.hive.formats.avro.model.EnumReadAction;
import io.trino.hive.formats.avro.model.FixedRead;
import io.trino.hive.formats.avro.model.FloatRead;
import io.trino.hive.formats.avro.model.IntRead;
import io.trino.hive.formats.avro.model.LongRead;
import io.trino.hive.formats.avro.model.MapReadAction;
import io.trino.hive.formats.avro.model.NullRead;
import io.trino.hive.formats.avro.model.ReadErrorReadAction;
import io.trino.hive.formats.avro.model.ReadingUnionReadAction;
import io.trino.hive.formats.avro.model.RecordReadAction;
import io.trino.hive.formats.avro.model.StringRead;
import io.trino.hive.formats.avro.model.WrittenUnionReadAction;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.Varchars;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;
import org.joda.time.DateTimeZone;

public class HiveAvroTypeBlockHandler
implements AvroTypeBlockHandler {
    private final TimestampType hiveSessionTimestamp;
    private final AtomicReference<ZoneId> convertToTimezone = new AtomicReference<ZoneOffset>(ZoneOffset.UTC);

    public HiveAvroTypeBlockHandler(TimestampType hiveSessionTimestamp) {
        this.hiveSessionTimestamp = Objects.requireNonNull(hiveSessionTimestamp, "hiveSessionTimestamp is null");
    }

    @Override
    public void configure(Map<String, byte[]> fileMetadata) {
        if (fileMetadata.containsKey("writer.time.zone")) {
            this.convertToTimezone.set(ZoneId.of(new String(fileMetadata.get("writer.time.zone"), StandardCharsets.UTF_8)));
        } else {
            this.convertToTimezone.set(TimeZone.getDefault().toZoneId());
        }
    }

    @Override
    public Type typeFor(Schema schema) throws AvroTypeException {
        NativeLogicalTypesAvroTypeManager.ValidateLogicalTypeResult logicalTypeResult;
        AvroTypeUtils.verifyNoCircularReferences(schema);
        if (schema.getType() == Schema.Type.NULL) {
            return BooleanType.BOOLEAN;
        }
        if (schema.getType() == Schema.Type.UNION) {
            if (AvroTypeUtils.isSimpleNullableUnion(schema)) {
                return this.typeFor(AvroTypeUtils.unwrapNullableUnion(schema));
            }
            return this.rowTypeForUnion(schema);
        }
        NativeLogicalTypesAvroTypeManager.ValidateLogicalTypeResult validateLogicalTypeResult = logicalTypeResult = NativeLogicalTypesAvroTypeManager.validateLogicalType(schema);
        Objects.requireNonNull(validateLogicalTypeResult);
        NativeLogicalTypesAvroTypeManager.ValidateLogicalTypeResult validateLogicalTypeResult2 = validateLogicalTypeResult;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NativeLogicalTypesAvroTypeManager.NoLogicalType.class, NativeLogicalTypesAvroTypeManager.InvalidNativeAvroLogicalType.class, NativeLogicalTypesAvroTypeManager.NonNativeAvroLogicalType.class, NativeLogicalTypesAvroTypeManager.ValidNativeAvroLogicalType.class}, (NativeLogicalTypesAvroTypeManager.ValidateLogicalTypeResult)validateLogicalTypeResult2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> BaseAvroTypeBlockHandlerImpls.baseTypeFor(schema, this);
            case 1 -> BaseAvroTypeBlockHandlerImpls.baseTypeFor(schema, this);
            case 2 -> {
                NativeLogicalTypesAvroTypeManager.NonNativeAvroLogicalType nonNativeAvroLogicalType = (NativeLogicalTypesAvroTypeManager.NonNativeAvroLogicalType)validateLogicalTypeResult2;
                switch (nonNativeAvroLogicalType.getLogicalTypeName()) {
                    case "varchar": 
                    case "char": {
                        yield HiveAvroTypeManager.getHiveLogicalVarCharOrCharType(schema, nonNativeAvroLogicalType);
                    }
                }
                yield BaseAvroTypeBlockHandlerImpls.baseTypeFor(schema, this);
            }
            case 3 -> {
                NativeLogicalTypesAvroTypeManager.ValidNativeAvroLogicalType validNativeAvroLogicalType = (NativeLogicalTypesAvroTypeManager.ValidNativeAvroLogicalType)validateLogicalTypeResult2;
                AvroLogicalType v2 = validNativeAvroLogicalType.getLogicalType();
                Objects.requireNonNull(v2);
                AvroLogicalType var9_10 = v2;
                int var10_11 = 0;
                while (true) {
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AvroLogicalType.DateLogicalType.class, AvroLogicalType.BytesDecimalLogicalType.class, AvroLogicalType.TimestampMillisLogicalType.class, AvroLogicalType.FixedDecimalLogicalType.class, AvroLogicalType.TimeMicrosLogicalType.class, AvroLogicalType.TimeMillisLogicalType.class, AvroLogicalType.TimestampMicrosLogicalType.class, AvroLogicalType.StringUUIDLogicalType.class}, (AvroLogicalType)var9_10, var10_11)) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            AvroLogicalType.DateLogicalType dateLogicalType = (AvroLogicalType.DateLogicalType)var9_10;
                            yield NativeLogicalTypesAvroTypeManager.getAvroLogicalTypeSpiType(dateLogicalType);
                        }
                        case 1: {
                            AvroLogicalType.BytesDecimalLogicalType bytesDecimalLogicalType = (AvroLogicalType.BytesDecimalLogicalType)var9_10;
                            yield NativeLogicalTypesAvroTypeManager.getAvroLogicalTypeSpiType(bytesDecimalLogicalType);
                        }
                        case 2: {
                            yield this.hiveSessionTimestamp;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                    }
                    if (var9_10 instanceof AvroLogicalType.FixedDecimalLogicalType || var9_10 instanceof AvroLogicalType.TimeMicrosLogicalType || var9_10 instanceof AvroLogicalType.TimeMillisLogicalType || var9_10 instanceof AvroLogicalType.TimestampMicrosLogicalType || var9_10 instanceof AvroLogicalType.StringUUIDLogicalType) break;
                    var10_11 = 8;
                }
                yield BaseAvroTypeBlockHandlerImpls.baseTypeFor(schema, this);
            }
        };
    }

    private RowType rowTypeForUnion(Schema schema) throws AvroTypeException {
        Verify.verify((boolean)schema.isUnion());
        ImmutableList.Builder unionTypes = ImmutableList.builder();
        for (Schema variant : schema.getTypes()) {
            if (variant.isNullable()) continue;
            unionTypes.add((Object)this.typeFor(variant));
        }
        return UnionToRowCoercionUtils.rowTypeForUnionOfTypes((List<Type>)unionTypes.build());
    }

    @Override
    public BlockBuildingDecoder blockBuildingDecoderFor(AvroReadAction readAction) throws AvroTypeException {
        NativeLogicalTypesAvroTypeManager.ValidateLogicalTypeResult logicalTypeResult;
        NativeLogicalTypesAvroTypeManager.ValidateLogicalTypeResult validateLogicalTypeResult = logicalTypeResult = NativeLogicalTypesAvroTypeManager.validateLogicalType(readAction.readSchema());
        Objects.requireNonNull(validateLogicalTypeResult);
        NativeLogicalTypesAvroTypeManager.ValidateLogicalTypeResult validateLogicalTypeResult2 = validateLogicalTypeResult;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NativeLogicalTypesAvroTypeManager.NoLogicalType.class, NativeLogicalTypesAvroTypeManager.InvalidNativeAvroLogicalType.class, NativeLogicalTypesAvroTypeManager.NonNativeAvroLogicalType.class, NativeLogicalTypesAvroTypeManager.ValidNativeAvroLogicalType.class}, (NativeLogicalTypesAvroTypeManager.ValidateLogicalTypeResult)validateLogicalTypeResult2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> this.baseBlockBuildingDecoderWithUnionCoerceAndErrorDelays(readAction);
            case 1 -> this.baseBlockBuildingDecoderWithUnionCoerceAndErrorDelays(readAction);
            case 2 -> {
                NativeLogicalTypesAvroTypeManager.NonNativeAvroLogicalType nonNativeAvroLogicalType = (NativeLogicalTypesAvroTypeManager.NonNativeAvroLogicalType)validateLogicalTypeResult2;
                switch (nonNativeAvroLogicalType.getLogicalTypeName()) {
                    case "varchar": {
                        yield new HiveVarcharTypeBlockBuildingDecoder(HiveAvroTypeManager.getHiveLogicalVarCharOrCharType(readAction.readSchema(), nonNativeAvroLogicalType));
                    }
                    case "char": {
                        yield new HiveCharTypeBlockBuildingDecoder(HiveAvroTypeManager.getHiveLogicalVarCharOrCharType(readAction.readSchema(), nonNativeAvroLogicalType));
                    }
                }
                yield this.baseBlockBuildingDecoderWithUnionCoerceAndErrorDelays(readAction);
            }
            case 3 -> {
                NativeLogicalTypesAvroTypeManager.ValidNativeAvroLogicalType validNativeAvroLogicalType = (NativeLogicalTypesAvroTypeManager.ValidNativeAvroLogicalType)validateLogicalTypeResult2;
                AvroLogicalType v2 = validNativeAvroLogicalType.getLogicalType();
                Objects.requireNonNull(v2);
                AvroLogicalType var9_10 = v2;
                int var10_11 = 0;
                while (true) {
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AvroLogicalType.DateLogicalType.class, AvroLogicalType.BytesDecimalLogicalType.class, AvroLogicalType.TimestampMillisLogicalType.class, AvroLogicalType.FixedDecimalLogicalType.class, AvroLogicalType.TimeMicrosLogicalType.class, AvroLogicalType.TimeMillisLogicalType.class, AvroLogicalType.TimestampMicrosLogicalType.class, AvroLogicalType.StringUUIDLogicalType.class}, (AvroLogicalType)var9_10, var10_11)) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            AvroLogicalType.DateLogicalType dateLogicalType = (AvroLogicalType.DateLogicalType)var9_10;
                            yield NativeLogicalTypesAvroTypeBlockHandler.getLogicalTypeBuildingFunction(dateLogicalType, readAction);
                        }
                        case 1: {
                            AvroLogicalType.BytesDecimalLogicalType bytesDecimalLogicalType = (AvroLogicalType.BytesDecimalLogicalType)var9_10;
                            yield NativeLogicalTypesAvroTypeBlockHandler.getLogicalTypeBuildingFunction(bytesDecimalLogicalType, readAction);
                        }
                        case 2: {
                            yield new HiveCoercesedTimestampBlockBuildingDecoder(this.hiveSessionTimestamp, readAction, this.convertToTimezone);
                        }
                        case 3: {
                            yield this.baseBlockBuildingDecoderWithUnionCoerceAndErrorDelays(readAction);
                        }
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                    }
                    if (var9_10 instanceof AvroLogicalType.TimeMicrosLogicalType || var9_10 instanceof AvroLogicalType.TimeMillisLogicalType || var9_10 instanceof AvroLogicalType.TimestampMicrosLogicalType || var9_10 instanceof AvroLogicalType.StringUUIDLogicalType) break;
                    var10_11 = 8;
                }
                yield this.baseBlockBuildingDecoderWithUnionCoerceAndErrorDelays(readAction);
            }
        };
    }

    private BlockBuildingDecoder baseBlockBuildingDecoderWithUnionCoerceAndErrorDelays(AvroReadAction readAction) throws AvroTypeException {
        BlockBuildingDecoder blockBuildingDecoder;
        AvroReadAction avroReadAction = readAction;
        Objects.requireNonNull(avroReadAction);
        AvroReadAction avroReadAction2 = avroReadAction;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NullRead.class, BooleanRead.class, IntRead.class, LongRead.class, FloatRead.class, DoubleRead.class, StringRead.class, BytesRead.class, FixedRead.class, ArrayReadAction.class, EnumReadAction.class, MapReadAction.class, RecordReadAction.class, WrittenUnionReadAction.class, ReadingUnionReadAction.class, ReadErrorReadAction.class}, (AvroReadAction)avroReadAction2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    if (!(avroReadAction2 instanceof NullRead || avroReadAction2 instanceof BooleanRead || avroReadAction2 instanceof IntRead || avroReadAction2 instanceof LongRead || avroReadAction2 instanceof FloatRead || avroReadAction2 instanceof DoubleRead || avroReadAction2 instanceof StringRead || avroReadAction2 instanceof BytesRead || avroReadAction2 instanceof FixedRead || avroReadAction2 instanceof ArrayReadAction || avroReadAction2 instanceof EnumReadAction || avroReadAction2 instanceof MapReadAction || avroReadAction2 instanceof RecordReadAction)) {
                        n = 13;
                        continue block6;
                    }
                    blockBuildingDecoder = BaseAvroTypeBlockHandlerImpls.baseBlockBuildingDecoderFor(readAction, this);
                    break block6;
                }
                case 13: {
                    WrittenUnionReadAction writtenUnionReadAction = (WrittenUnionReadAction)avroReadAction2;
                    if (writtenUnionReadAction.readSchema().getType() == Schema.Type.UNION && !AvroTypeUtils.isSimpleNullableUnion(writtenUnionReadAction.readSchema())) {
                        blockBuildingDecoder = new WriterUnionCoercedIntoRowBlockBuildingDecoder(writtenUnionReadAction, this);
                        break block6;
                    }
                    blockBuildingDecoder = new BaseAvroTypeBlockHandlerImpls.WriterUnionBlockBuildingDecoder(writtenUnionReadAction, this);
                    break block6;
                }
                case 14: {
                    ReadingUnionReadAction readingUnionReadAction = (ReadingUnionReadAction)avroReadAction2;
                    if (AvroTypeUtils.isSimpleNullableUnion(readingUnionReadAction.readSchema())) {
                        blockBuildingDecoder = this.blockBuildingDecoderFor(readingUnionReadAction.actualAction());
                        break block6;
                    }
                    blockBuildingDecoder = new ReaderUnionCoercedIntoRowBlockBuildingDecoder(readingUnionReadAction, this);
                    break block6;
                }
                case 15: {
                    ReadErrorReadAction readErrorReadAction = (ReadErrorReadAction)avroReadAction2;
                    blockBuildingDecoder = new TypeErrorThrower(readErrorReadAction);
                    break block6;
                }
            }
            break;
        }
        return blockBuildingDecoder;
    }

    private static class HiveVarcharTypeBlockBuildingDecoder
    implements BlockBuildingDecoder {
        private final Type type;

        public HiveVarcharTypeBlockBuildingDecoder(Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
        }

        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            long size = decoder.readLong();
            if (size > 0x7FFFFFF7L) {
                throw new IOException("Unable to read avro String with size greater than %s. Found String size: %s".formatted(0x7FFFFFF7L, size));
            }
            byte[] bytes = new byte[(int)size];
            decoder.readFixed(bytes);
            this.type.writeSlice(builder, Varchars.truncateToLength((Slice)Slices.wrappedBuffer((byte[])bytes), (Type)this.type));
        }
    }

    private static class HiveCharTypeBlockBuildingDecoder
    implements BlockBuildingDecoder {
        private final Type type;

        public HiveCharTypeBlockBuildingDecoder(Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
        }

        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            long size = decoder.readLong();
            if (size > 0x7FFFFFF7L) {
                throw new IOException("Unable to read avro String with size greater than %s. Found String size: %s".formatted(0x7FFFFFF7L, size));
            }
            byte[] bytes = new byte[(int)size];
            decoder.readFixed(bytes);
            this.type.writeSlice(builder, Chars.truncateToLengthAndTrimSpaces((Slice)Slices.wrappedBuffer((byte[])bytes), (Type)this.type));
        }
    }

    private static class HiveCoercesedTimestampBlockBuildingDecoder
    implements BlockBuildingDecoder {
        private final TimestampType hiveSessionTimestamp;
        private final AvroReadAction.LongIoFunction<Decoder> longDecoder;
        private final AtomicReference<ZoneId> convertToTimezone;

        public HiveCoercesedTimestampBlockBuildingDecoder(TimestampType hiveSessionTimestamp, AvroReadAction avroReadAction, AtomicReference<ZoneId> convertToTimezone) {
            Preconditions.checkArgument((boolean)(avroReadAction instanceof LongRead), (Object)"TimestampMillis type can only be read from Long Avro type");
            this.hiveSessionTimestamp = Objects.requireNonNull(hiveSessionTimestamp, "hiveSessionTimestamp is null");
            this.longDecoder = ((LongRead)avroReadAction).getLongDecoder();
            this.convertToTimezone = Objects.requireNonNull(convertToTimezone, "convertToTimezone is null");
        }

        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            long millisSinceEpochUTC = this.longDecoder.apply(decoder);
            if (this.hiveSessionTimestamp.isShort()) {
                this.hiveSessionTimestamp.writeLong(builder, DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(this.convertToTimezone.get())).convertUTCToLocal(millisSinceEpochUTC) * 1000L);
            } else {
                LongTimestamp longTimestamp = new LongTimestamp(DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(this.convertToTimezone.get())).convertUTCToLocal(millisSinceEpochUTC) * 1000L, 0);
                this.hiveSessionTimestamp.writeObject(builder, (Object)longTimestamp);
            }
        }
    }

    public static class WriterUnionCoercedIntoRowBlockBuildingDecoder
    extends BaseAvroTypeBlockHandlerImpls.WriterUnionBlockBuildingDecoder {
        private final boolean readUnionEquiv;
        private final int[] indexToChannel;
        private final int totalChannels;

        public WriterUnionCoercedIntoRowBlockBuildingDecoder(WrittenUnionReadAction writtenUnionReadAction, AvroTypeBlockHandler avroTypeManager) throws AvroTypeException {
            super(writtenUnionReadAction, avroTypeManager);
            this.readUnionEquiv = writtenUnionReadAction.unionEqiv();
            List readSchemas = writtenUnionReadAction.readSchema().getTypes();
            Preconditions.checkArgument((readSchemas.size() == writtenUnionReadAction.writeOptionReadActions().size() ? 1 : 0) != 0, (Object)"each read schema must have resolvedAction For it");
            this.indexToChannel = WriterUnionCoercedIntoRowBlockBuildingDecoder.getIndexToChannel(readSchemas);
            this.totalChannels = (int)IntStream.of(this.indexToChannel).filter(i -> i >= 0).count();
        }

        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            int index = decoder.readIndex();
            if (this.readUnionEquiv) {
                if (this.indexToChannel[index] < 0) {
                    BaseAvroTypeBlockHandlerImpls.NullBlockBuildingDecoder.INSTANCE.decodeIntoBlock(decoder, builder);
                } else {
                    WriterUnionCoercedIntoRowBlockBuildingDecoder.makeSingleRowWithTagAndAllFieldsNullButOne(this.indexToChannel[index], this.totalChannels, this.blockBuildingDecoders[index], decoder, builder);
                }
            } else {
                this.decodeIntoBlock(index, decoder, builder);
            }
        }

        protected static void makeSingleRowWithTagAndAllFieldsNullButOne(int outputChannel, int totalChannels, BlockBuildingDecoder blockBuildingDecoder, Decoder decoder, BlockBuilder builder) throws IOException {
            ((RowBlockBuilder)builder).buildEntry(fieldBuilders -> {
                UnionToRowCoercionUtils.UNION_FIELD_TAG_TYPE.writeLong((BlockBuilder)fieldBuilders.getFirst(), (long)outputChannel);
                for (int channel = 1; channel <= totalChannels; ++channel) {
                    if (channel == outputChannel + 1) {
                        blockBuildingDecoder.decodeIntoBlock(decoder, (BlockBuilder)fieldBuilders.get(channel));
                        continue;
                    }
                    ((BlockBuilder)fieldBuilders.get(channel)).appendNull();
                }
            });
        }

        protected static int[] getIndexToChannel(List<Schema> schemas) {
            int[] indexToChannel = new int[schemas.size()];
            int outputChannel = 0;
            for (int i = 0; i < indexToChannel.length; ++i) {
                indexToChannel[i] = schemas.get(i).getType() == Schema.Type.NULL ? -1 : outputChannel++;
            }
            return indexToChannel;
        }
    }

    public static class ReaderUnionCoercedIntoRowBlockBuildingDecoder
    implements BlockBuildingDecoder {
        private final BlockBuildingDecoder delegateBuilder;
        private final int outputChannel;
        private final int totalChannels;

        public ReaderUnionCoercedIntoRowBlockBuildingDecoder(ReadingUnionReadAction readingUnionReadAction, AvroTypeBlockHandler avroTypeManager) throws AvroTypeException {
            Objects.requireNonNull(readingUnionReadAction, "readerUnion is null");
            Objects.requireNonNull(avroTypeManager, "avroTypeManger is null");
            int[] indexToChannel = WriterUnionCoercedIntoRowBlockBuildingDecoder.getIndexToChannel(readingUnionReadAction.readSchema().getTypes());
            this.outputChannel = indexToChannel[readingUnionReadAction.firstMatch()];
            this.delegateBuilder = avroTypeManager.blockBuildingDecoderFor(readingUnionReadAction.actualAction());
            this.totalChannels = (int)IntStream.of(indexToChannel).filter(i -> i >= 0).count();
        }

        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            if (this.outputChannel < 0) {
                BaseAvroTypeBlockHandlerImpls.NullBlockBuildingDecoder.INSTANCE.decodeIntoBlock(decoder, builder);
            } else {
                WriterUnionCoercedIntoRowBlockBuildingDecoder.makeSingleRowWithTagAndAllFieldsNullButOne(this.outputChannel, this.totalChannels, this.delegateBuilder, decoder, builder);
            }
        }
    }

    private static class TypeErrorThrower
    implements BlockBuildingDecoder {
        private final ReadErrorReadAction action;

        public TypeErrorThrower(ReadErrorReadAction action) {
            this.action = Objects.requireNonNull(action, "action is null");
        }

        @Override
        public void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            throw new IOException(new AvroTypeException("Resolution action returned with error " + String.valueOf(this.action)));
        }
    }
}

