/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.avro.model;

import com.google.common.base.Verify;
import io.trino.hive.formats.avro.model.AvroReadAction;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;

public final class LongRead
implements AvroReadAction {
    private final Schema readSchema;
    private final Schema writeSchema;
    private final AvroReadAction.LongIoFunction<Decoder> longDecoder;

    LongRead(Schema readSchema, Schema writeSchema) {
        this.readSchema = Objects.requireNonNull(readSchema, "readSchema is null");
        this.writeSchema = Objects.requireNonNull(writeSchema, "writeSchema is null");
        Verify.verify((readSchema.getType() == Schema.Type.LONG ? 1 : 0) != 0);
        this.longDecoder = AvroReadAction.getLongDecoderFunction(writeSchema);
    }

    @Override
    public Schema readSchema() {
        return this.readSchema;
    }

    @Override
    public Schema writeSchema() {
        return this.writeSchema;
    }

    public AvroReadAction.LongIoFunction<Decoder> getLongDecoder() {
        return this.longDecoder;
    }
}

