/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.compression;

import io.airlift.compress.v3.hadoop.HadoopOutputStream;
import io.airlift.compress.v3.hadoop.HadoopStreams;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

public final class ValueCompressor {
    private final HadoopStreams hadoopStreams;
    private final DynamicSliceOutput buffer;

    ValueCompressor(HadoopStreams hadoopStreams) {
        this.hadoopStreams = Objects.requireNonNull(hadoopStreams, "hadoopStreams is null");
        this.buffer = new DynamicSliceOutput(1024);
    }

    public Slice compress(Slice slice) throws IOException {
        this.buffer.reset();
        try (HadoopOutputStream compressionStream = this.hadoopStreams.createOutputStream((OutputStream)this.buffer);){
            slice.getInput().transferTo((OutputStream)compressionStream);
        }
        return this.buffer.slice();
    }
}

