/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.encodings.text;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.hive.formats.encodings.ColumnData;
import io.trino.hive.formats.encodings.EncodeOutput;
import io.trino.hive.formats.encodings.text.TextColumnEncoding;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;

public class LongEncoding
implements TextColumnEncoding {
    private final Type type;
    private final Slice nullSequence;
    private final StringBuilder buffer = new StringBuilder();

    public LongEncoding(Type type, Slice nullSequence) {
        this.type = type;
        this.nullSequence = nullSequence;
    }

    @Override
    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                output.writeBytes(this.nullSequence);
            } else {
                long value = this.type.getLong(block, position);
                this.buffer.setLength(0);
                this.buffer.append(value);
                for (int index = 0; index < this.buffer.length(); ++index) {
                    output.writeByte((int)this.buffer.charAt(index));
                }
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public void encodeValueInto(Block block, int position, SliceOutput output) {
        long value = this.type.getLong(block, position);
        this.buffer.setLength(0);
        this.buffer.append(value);
        for (int index = 0; index < this.buffer.length(); ++index) {
            output.writeByte((int)this.buffer.charAt(index));
        }
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int offset = columnData.getOffset(i);
            int length = columnData.getLength(i);
            if (length == 0 || this.nullSequence.equals(0, this.nullSequence.length(), slice, offset, length)) {
                builder.appendNull();
                continue;
            }
            this.decodeValue(builder, slice, offset, length);
        }
        return builder.build();
    }

    @Override
    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) {
        this.decodeValue(builder, slice, offset, length);
    }

    private void decodeValue(BlockBuilder builder, Slice slice, int offset, int length) {
        if (length == 0) {
            builder.appendNull();
            return;
        }
        try {
            this.type.writeLong(builder, LongEncoding.parseLong(slice, offset, length));
        }
        catch (TrinoException e) {
            if (e.getErrorCode() != StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode()) {
                throw e;
            }
            builder.appendNull();
        }
        catch (NumberFormatException numberFormatException) {
            builder.appendNull();
        }
    }

    private static long parseLong(Slice slice, int start, int length) {
        int limit = start + length;
        boolean negative = false;
        if (slice.getByte(start) == 45) {
            negative = true;
            ++start;
        } else if (slice.getByte(start) == 43) {
            ++start;
        }
        if (start == limit) {
            throw new NumberFormatException();
        }
        while (start < limit && slice.getByte(start) == 48) {
            ++start;
        }
        if ((limit = LongEncoding.truncateDecimal(slice, start, limit)) - start > 19) {
            throw new NumberFormatException();
        }
        long value = 0L;
        while (start < limit) {
            byte b = slice.getByte(start);
            ++start;
            if ((value = value * 10L + (long)LongEncoding.toDigit(b)) >= 0L || value == Long.MIN_VALUE) continue;
            throw new NumberFormatException();
        }
        if (negative ? (value = -value) > 0L : value < 0L) {
            throw new NumberFormatException();
        }
        return value;
    }

    private static int truncateDecimal(Slice slice, int start, int limit) {
        for (int position = start; position < limit; ++position) {
            byte b = slice.getByte(position);
            if (b != 46) continue;
            for (int decimalPosition = position + 1; decimalPosition < limit; ++decimalPosition) {
                LongEncoding.toDigit(slice.getByte(decimalPosition));
            }
            return position;
        }
        return limit;
    }

    private static int toDigit(byte b) {
        if (b > 57 || b < 48) {
            throw new NumberFormatException();
        }
        return b - 48;
    }
}

