/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import java.util.Objects;
import java.util.Set;

public class OrcWriterOptions {
    @VisibleForTesting
    static final DataSize DEFAULT_MAX_STRING_STATISTICS_LIMIT = DataSize.ofBytes((long)64L);
    @VisibleForTesting
    static final DataSize DEFAULT_MAX_COMPRESSION_BUFFER_SIZE = DataSize.of((long)256L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    static final double DEFAULT_BLOOM_FILTER_FPP = 0.05;
    private static final DataSize DEFAULT_STRIPE_MIN_SIZE = DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final DataSize DEFAULT_STRIPE_MAX_SIZE = DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final int DEFAULT_STRIPE_MAX_ROW_COUNT = 10000000;
    private static final int DEFAULT_ROW_GROUP_MAX_ROW_COUNT = 10000;
    private static final DataSize DEFAULT_DICTIONARY_MAX_MEMORY = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private final DataSize stripeMinSize;
    private final DataSize stripeMaxSize;
    private final int stripeMaxRowCount;
    private final int rowGroupMaxRowCount;
    private final DataSize dictionaryMaxMemory;
    private final DataSize maxStringStatisticsLimit;
    private final DataSize maxCompressionBufferSize;
    private final Set<String> bloomFilterColumns;
    private final double bloomFilterFpp;

    public OrcWriterOptions() {
        this(DEFAULT_STRIPE_MIN_SIZE, DEFAULT_STRIPE_MAX_SIZE, 10000000, 10000, DEFAULT_DICTIONARY_MAX_MEMORY, DEFAULT_MAX_STRING_STATISTICS_LIMIT, DEFAULT_MAX_COMPRESSION_BUFFER_SIZE, (Set<String>)ImmutableSet.of(), 0.05);
    }

    private OrcWriterOptions(DataSize stripeMinSize, DataSize stripeMaxSize, int stripeMaxRowCount, int rowGroupMaxRowCount, DataSize dictionaryMaxMemory, DataSize maxStringStatisticsLimit, DataSize maxCompressionBufferSize, Set<String> bloomFilterColumns, double bloomFilterFpp) {
        Objects.requireNonNull(stripeMinSize, "stripeMinSize is null");
        Objects.requireNonNull(stripeMaxSize, "stripeMaxSize is null");
        Preconditions.checkArgument((stripeMaxRowCount >= 1 ? 1 : 0) != 0, (Object)"stripeMaxRowCount must be at least 1");
        Preconditions.checkArgument((rowGroupMaxRowCount >= 1 ? 1 : 0) != 0, (Object)"rowGroupMaxRowCount must be at least 1");
        Objects.requireNonNull(dictionaryMaxMemory, "dictionaryMaxMemory is null");
        Objects.requireNonNull(maxStringStatisticsLimit, "maxStringStatisticsLimit is null");
        Objects.requireNonNull(maxCompressionBufferSize, "maxCompressionBufferSize is null");
        Objects.requireNonNull(bloomFilterColumns, "bloomFiltersColumns is null");
        Preconditions.checkArgument((bloomFilterFpp > 0.0 && bloomFilterFpp < 1.0 ? 1 : 0) != 0, (Object)"bloomFilterFpp should be > 0.0 & < 1.0");
        this.stripeMinSize = stripeMinSize;
        this.stripeMaxSize = stripeMaxSize;
        this.stripeMaxRowCount = stripeMaxRowCount;
        this.rowGroupMaxRowCount = rowGroupMaxRowCount;
        this.dictionaryMaxMemory = dictionaryMaxMemory;
        this.maxStringStatisticsLimit = maxStringStatisticsLimit;
        this.maxCompressionBufferSize = maxCompressionBufferSize;
        this.bloomFilterColumns = ImmutableSet.copyOf(bloomFilterColumns);
        this.bloomFilterFpp = bloomFilterFpp;
    }

    public DataSize getStripeMinSize() {
        return this.stripeMinSize;
    }

    public DataSize getStripeMaxSize() {
        return this.stripeMaxSize;
    }

    public int getStripeMaxRowCount() {
        return this.stripeMaxRowCount;
    }

    public int getRowGroupMaxRowCount() {
        return this.rowGroupMaxRowCount;
    }

    public DataSize getDictionaryMaxMemory() {
        return this.dictionaryMaxMemory;
    }

    public DataSize getMaxStringStatisticsLimit() {
        return this.maxStringStatisticsLimit;
    }

    public DataSize getMaxCompressionBufferSize() {
        return this.maxCompressionBufferSize;
    }

    public double getBloomFilterFpp() {
        return this.bloomFilterFpp;
    }

    public boolean isBloomFilterColumn(String columnName) {
        return this.bloomFilterColumns.contains(columnName);
    }

    public OrcWriterOptions withStripeMinSize(DataSize stripeMinSize) {
        return new OrcWriterOptions(stripeMinSize, this.stripeMaxSize, this.stripeMaxRowCount, this.rowGroupMaxRowCount, this.dictionaryMaxMemory, this.maxStringStatisticsLimit, this.maxCompressionBufferSize, this.bloomFilterColumns, this.bloomFilterFpp);
    }

    public OrcWriterOptions withStripeMaxSize(DataSize stripeMaxSize) {
        return new OrcWriterOptions(this.stripeMinSize, stripeMaxSize, this.stripeMaxRowCount, this.rowGroupMaxRowCount, this.dictionaryMaxMemory, this.maxStringStatisticsLimit, this.maxCompressionBufferSize, this.bloomFilterColumns, this.bloomFilterFpp);
    }

    public OrcWriterOptions withStripeMaxRowCount(int stripeMaxRowCount) {
        return new OrcWriterOptions(this.stripeMinSize, this.stripeMaxSize, stripeMaxRowCount, this.rowGroupMaxRowCount, this.dictionaryMaxMemory, this.maxStringStatisticsLimit, this.maxCompressionBufferSize, this.bloomFilterColumns, this.bloomFilterFpp);
    }

    public OrcWriterOptions withRowGroupMaxRowCount(int rowGroupMaxRowCount) {
        return new OrcWriterOptions(this.stripeMinSize, this.stripeMaxSize, this.stripeMaxRowCount, rowGroupMaxRowCount, this.dictionaryMaxMemory, this.maxStringStatisticsLimit, this.maxCompressionBufferSize, this.bloomFilterColumns, this.bloomFilterFpp);
    }

    public OrcWriterOptions withDictionaryMaxMemory(DataSize dictionaryMaxMemory) {
        return new OrcWriterOptions(this.stripeMinSize, this.stripeMaxSize, this.stripeMaxRowCount, this.rowGroupMaxRowCount, dictionaryMaxMemory, this.maxStringStatisticsLimit, this.maxCompressionBufferSize, this.bloomFilterColumns, this.bloomFilterFpp);
    }

    public OrcWriterOptions withMaxStringStatisticsLimit(DataSize maxStringStatisticsLimit) {
        return new OrcWriterOptions(this.stripeMinSize, this.stripeMaxSize, this.stripeMaxRowCount, this.rowGroupMaxRowCount, this.dictionaryMaxMemory, maxStringStatisticsLimit, this.maxCompressionBufferSize, this.bloomFilterColumns, this.bloomFilterFpp);
    }

    public OrcWriterOptions withMaxCompressionBufferSize(DataSize maxCompressionBufferSize) {
        return new OrcWriterOptions(this.stripeMinSize, this.stripeMaxSize, this.stripeMaxRowCount, this.rowGroupMaxRowCount, this.dictionaryMaxMemory, this.maxStringStatisticsLimit, maxCompressionBufferSize, this.bloomFilterColumns, this.bloomFilterFpp);
    }

    public OrcWriterOptions withBloomFilterColumns(Set<String> bloomFilterColumns) {
        return new OrcWriterOptions(this.stripeMinSize, this.stripeMaxSize, this.stripeMaxRowCount, this.rowGroupMaxRowCount, this.dictionaryMaxMemory, this.maxStringStatisticsLimit, this.maxCompressionBufferSize, bloomFilterColumns, this.bloomFilterFpp);
    }

    public OrcWriterOptions withBloomFilterFpp(double bloomFilterFpp) {
        return new OrcWriterOptions(this.stripeMinSize, this.stripeMaxSize, this.stripeMaxRowCount, this.rowGroupMaxRowCount, this.dictionaryMaxMemory, this.maxStringStatisticsLimit, this.maxCompressionBufferSize, this.bloomFilterColumns, bloomFilterFpp);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stripeMinSize", (Object)this.stripeMinSize).add("stripeMaxSize", (Object)this.stripeMaxSize).add("stripeMaxRowCount", this.stripeMaxRowCount).add("rowGroupMaxRowCount", this.rowGroupMaxRowCount).add("dictionaryMaxMemory", (Object)this.dictionaryMaxMemory).add("maxStringStatisticsLimit", (Object)this.maxStringStatisticsLimit).add("maxCompressionBufferSize", (Object)this.maxCompressionBufferSize).add("bloomFilterColumns", this.bloomFilterColumns).add("bloomFilterFpp", this.bloomFilterFpp).toString();
    }
}

