/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.orc.OrcPredicate;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.OrcColumnId;
import io.trino.orc.metadata.statistics.BloomFilter;
import io.trino.orc.metadata.statistics.BooleanStatistics;
import io.trino.orc.metadata.statistics.ColumnStatistics;
import io.trino.orc.metadata.statistics.RangeStatistics;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class TupleDomainOrcPredicate
implements OrcPredicate {
    private final List<ColumnDomain> columnDomains;
    private final boolean orcBloomFiltersEnabled;

    public static TupleDomainOrcPredicateBuilder builder() {
        return new TupleDomainOrcPredicateBuilder();
    }

    private TupleDomainOrcPredicate(List<ColumnDomain> columnDomains, boolean orcBloomFiltersEnabled) {
        this.columnDomains = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnDomains, "columnDomains is null"));
        this.orcBloomFiltersEnabled = orcBloomFiltersEnabled;
    }

    @Override
    public boolean matches(long numberOfRows, ColumnMetadata<ColumnStatistics> allColumnStatistics) {
        for (ColumnDomain column : this.columnDomains) {
            ColumnStatistics columnStatistics = allColumnStatistics.get(column.getColumnId());
            if (columnStatistics == null || this.columnOverlaps(column.getDomain(), numberOfRows, columnStatistics)) continue;
            return false;
        }
        return true;
    }

    private boolean columnOverlaps(Domain predicateDomain, long numberOfRows, ColumnStatistics columnStatistics) {
        Domain stripeDomain = TupleDomainOrcPredicate.getDomain(predicateDomain.getType(), numberOfRows, columnStatistics);
        if (!stripeDomain.overlaps(predicateDomain)) {
            return false;
        }
        if (!this.orcBloomFiltersEnabled) {
            return true;
        }
        if (predicateDomain.isNullAllowed() && stripeDomain.isNullAllowed()) {
            return true;
        }
        Optional<Collection<Object>> discreteValues = TupleDomainOrcPredicate.extractDiscreteValues(predicateDomain.getValues());
        if (discreteValues.isEmpty()) {
            return true;
        }
        BloomFilter bloomFilter = columnStatistics.getBloomFilter();
        if (bloomFilter == null) {
            return true;
        }
        return discreteValues.get().stream().anyMatch(value -> TupleDomainOrcPredicate.checkInBloomFilter(bloomFilter, value, stripeDomain.getType()));
    }

    private static Optional<Collection<Object>> extractDiscreteValues(ValueSet valueSet) {
        if (!valueSet.isDiscreteSet()) {
            return Optional.empty();
        }
        return Optional.of(valueSet.getDiscreteSet());
    }

    @VisibleForTesting
    public static boolean checkInBloomFilter(BloomFilter bloomFilter, Object predicateValue, Type sqlType) {
        if (sqlType == TinyintType.TINYINT || sqlType == SmallintType.SMALLINT || sqlType == IntegerType.INTEGER || sqlType == BigintType.BIGINT || sqlType == DateType.DATE) {
            return bloomFilter.testLong(((Number)predicateValue).longValue());
        }
        if (sqlType == DoubleType.DOUBLE) {
            return bloomFilter.testDouble((Double)predicateValue);
        }
        if (sqlType == RealType.REAL) {
            return bloomFilter.testFloat(Float.intBitsToFloat(((Number)predicateValue).intValue()));
        }
        if (sqlType instanceof VarcharType || sqlType instanceof VarbinaryType) {
            return bloomFilter.testSlice((Slice)predicateValue);
        }
        if (sqlType.equals(TimestampType.TIMESTAMP_MILLIS)) {
            return bloomFilter.testLong(((Number)predicateValue).longValue());
        }
        if (sqlType.equals(TimestampType.TIMESTAMP_MICROS)) {
            return bloomFilter.testLong(Math.floorDiv(((Number)predicateValue).longValue(), 1000));
        }
        if (sqlType.equals(TimestampType.TIMESTAMP_NANOS)) {
            return bloomFilter.testLong(Math.floorDiv(((LongTimestamp)predicateValue).getEpochMicros(), 1000));
        }
        if (sqlType.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)) {
            return bloomFilter.testLong(DateTimeEncoding.unpackMillisUtc((long)((Number)predicateValue).longValue()));
        }
        if (sqlType.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS) || sqlType.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS)) {
            return bloomFilter.testLong(((LongTimestampWithTimeZone)predicateValue).getEpochMillis());
        }
        return true;
    }

    @VisibleForTesting
    public static Domain getDomain(Type type, long rowCount, ColumnStatistics columnStatistics) {
        boolean hasNullValue;
        if (rowCount == 0L) {
            return Domain.none((Type)type);
        }
        if (columnStatistics == null) {
            return Domain.all((Type)type);
        }
        if (columnStatistics.hasNumberOfValues() && columnStatistics.getNumberOfValues() == 0L) {
            return Domain.onlyNull((Type)type);
        }
        boolean bl = hasNullValue = columnStatistics.getNumberOfValues() != rowCount;
        if (type instanceof TimeType && columnStatistics.getIntegerStatistics() != null) {
            return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getIntegerStatistics(), value -> value * 1000000L);
        }
        if (type.getJavaType() == Boolean.TYPE && columnStatistics.getBooleanStatistics() != null) {
            boolean hasFalseValues;
            BooleanStatistics booleanStatistics = columnStatistics.getBooleanStatistics();
            boolean hasTrueValues = booleanStatistics.getTrueValueCount() != 0L;
            boolean bl2 = hasFalseValues = columnStatistics.getNumberOfValues() != booleanStatistics.getTrueValueCount();
            if (hasTrueValues && hasFalseValues) {
                return Domain.all((Type)BooleanType.BOOLEAN);
            }
            if (hasTrueValues) {
                return Domain.create((ValueSet)ValueSet.of((Type)BooleanType.BOOLEAN, (Object)true, (Object[])new Object[0]), (boolean)hasNullValue);
            }
            if (hasFalseValues) {
                return Domain.create((ValueSet)ValueSet.of((Type)BooleanType.BOOLEAN, (Object)false, (Object[])new Object[0]), (boolean)hasNullValue);
            }
        } else {
            if (Decimals.isShortDecimal((Type)type) && columnStatistics.getDecimalStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getDecimalStatistics(), value -> Decimals.rescale((BigDecimal)value, (DecimalType)((DecimalType)type)).unscaledValue().longValue());
            }
            if (Decimals.isLongDecimal((Type)type) && columnStatistics.getDecimalStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getDecimalStatistics(), value -> Decimals.encodeUnscaledValue((BigInteger)Decimals.rescale((BigDecimal)value, (DecimalType)((DecimalType)type)).unscaledValue()));
            }
            if (type instanceof CharType && columnStatistics.getStringStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getStringStatistics(), value -> Chars.truncateToLengthAndTrimSpaces((Slice)value, (Type)type));
            }
            if (type instanceof VarcharType && columnStatistics.getStringStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getStringStatistics());
            }
            if (type instanceof DateType && columnStatistics.getDateStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getDateStatistics(), value -> (long)value);
            }
            if ((type.equals(TimestampType.TIMESTAMP_MILLIS) || type.equals(TimestampType.TIMESTAMP_MICROS)) && columnStatistics.getTimestampStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getTimestampStatistics(), min -> min * 1000L, max -> (max + 1L) * 1000L);
            }
            if (type.equals(TimestampType.TIMESTAMP_NANOS) && columnStatistics.getTimestampStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getTimestampStatistics(), min -> new LongTimestamp(min * 1000L, 0), max -> new LongTimestamp((max + 1L) * 1000L, 0));
            }
            if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS) && columnStatistics.getTimestampStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getTimestampStatistics(), value -> DateTimeEncoding.packDateTimeWithZone((long)value, (TimeZoneKey)TimeZoneKey.UTC_KEY));
            }
            if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS) && columnStatistics.getTimestampStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getTimestampStatistics(), min -> LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)min, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), max -> LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)max, (int)999000000, (TimeZoneKey)TimeZoneKey.UTC_KEY));
            }
            if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS) && columnStatistics.getTimestampStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getTimestampStatistics(), min -> LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)min, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), max -> LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)max, (int)999999000, (TimeZoneKey)TimeZoneKey.UTC_KEY));
            }
            if (type.getJavaType() == Long.TYPE && columnStatistics.getIntegerStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getIntegerStatistics());
            }
            if (type.getJavaType() == Double.TYPE && columnStatistics.getDoubleStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getDoubleStatistics());
            }
            if (RealType.REAL.equals((Object)type) && columnStatistics.getDoubleStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getDoubleStatistics(), value -> Float.floatToRawIntBits(value.floatValue()));
            }
        }
        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
    }

    private static <T extends Comparable<T>> Domain createDomain(Type type, boolean hasNullValue, RangeStatistics<T> rangeStatistics) {
        return TupleDomainOrcPredicate.createDomain(type, hasNullValue, rangeStatistics, value -> value);
    }

    private static <F, T extends Comparable<T>> Domain createDomain(Type type, boolean hasNullValue, RangeStatistics<F> rangeStatistics, Function<F, T> function) {
        return TupleDomainOrcPredicate.createDomain(type, hasNullValue, rangeStatistics, function, function);
    }

    private static <F, T extends Comparable<T>> Domain createDomain(Type type, boolean hasNullValue, RangeStatistics<F> rangeStatistics, Function<F, T> minFunction, Function<F, T> maxFunction) {
        F min = rangeStatistics.getMin();
        F max = rangeStatistics.getMax();
        if (min != null && max != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)type, minFunction.apply(min), (boolean)true, maxFunction.apply(max), (boolean)true), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        if (max != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)type, maxFunction.apply(max)), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        if (min != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, minFunction.apply(min)), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
    }

    private static class ColumnDomain {
        private final OrcColumnId columnId;
        private final Domain domain;

        public ColumnDomain(OrcColumnId columnId, Domain domain) {
            this.columnId = Objects.requireNonNull(columnId, "columnId is null");
            this.domain = Objects.requireNonNull(domain, "domain is null");
        }

        public OrcColumnId getColumnId() {
            return this.columnId;
        }

        public Domain getDomain() {
            return this.domain;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("columnId", (Object)this.columnId).add("domain", (Object)this.domain).toString();
        }
    }

    public static class TupleDomainOrcPredicateBuilder {
        private final List<ColumnDomain> columns = new ArrayList<ColumnDomain>();
        private boolean bloomFiltersEnabled;

        public TupleDomainOrcPredicateBuilder addColumn(OrcColumnId columnId, Domain domain) {
            Objects.requireNonNull(domain, "domain is null");
            this.columns.add(new ColumnDomain(columnId, domain));
            return this;
        }

        public TupleDomainOrcPredicateBuilder setBloomFiltersEnabled(boolean bloomFiltersEnabled) {
            this.bloomFiltersEnabled = bloomFiltersEnabled;
            return this;
        }

        public TupleDomainOrcPredicate build() {
            return new TupleDomainOrcPredicate(this.columns, this.bloomFiltersEnabled);
        }
    }
}

