/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.predicate;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.parquet.DictionaryPage;
import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.ParquetTimestampUtils;
import io.trino.parquet.RichColumnDescriptor;
import io.trino.parquet.dictionary.Dictionary;
import io.trino.parquet.predicate.DictionaryDescriptor;
import io.trino.parquet.predicate.ParquetDoubleStatistics;
import io.trino.parquet.predicate.ParquetIntegerStatistics;
import io.trino.parquet.predicate.ParquetRangeStatistics;
import io.trino.parquet.predicate.ParquetStringStatistics;
import io.trino.parquet.predicate.Predicate;
import io.trino.parquet.predicate.PredicateUtils;
import io.trino.plugin.base.type.TrinoTimestampEncoderFactory;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.parquet.column.statistics.BooleanStatistics;
import org.apache.parquet.column.statistics.DoubleStatistics;
import org.apache.parquet.column.statistics.FloatStatistics;
import org.apache.parquet.column.statistics.IntStatistics;
import org.apache.parquet.column.statistics.LongStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.schema.PrimitiveType;
import org.joda.time.DateTimeZone;

public class TupleDomainParquetPredicate
implements Predicate {
    private final TupleDomain<ColumnDescriptor> effectivePredicate;
    private final List<RichColumnDescriptor> columns;
    private final DateTimeZone timeZone;

    public TupleDomainParquetPredicate(TupleDomain<ColumnDescriptor> effectivePredicate, List<RichColumnDescriptor> columns, DateTimeZone timeZone) {
        this.effectivePredicate = Objects.requireNonNull(effectivePredicate, "effectivePredicate is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
    }

    @Override
    public boolean matches(long numberOfRows, Map<ColumnDescriptor, Statistics<?>> statistics, ParquetDataSourceId id) throws ParquetCorruptionException {
        if (numberOfRows == 0L) {
            return false;
        }
        if (this.effectivePredicate.isNone()) {
            return false;
        }
        Map effectivePredicateDomains = (Map)this.effectivePredicate.getDomains().orElseThrow(() -> new IllegalStateException("Effective predicate other than none should have domains"));
        for (RichColumnDescriptor column : this.columns) {
            Domain domain;
            Statistics<?> columnStatistics;
            Domain effectivePredicateDomain = (Domain)effectivePredicateDomains.get((Object)column);
            if (effectivePredicateDomain == null || (columnStatistics = statistics.get((Object)column)) == null || columnStatistics.isEmpty() || effectivePredicateDomain.overlaps(domain = TupleDomainParquetPredicate.getDomain(effectivePredicateDomain.getType(), numberOfRows, columnStatistics, id, column.toString(), this.timeZone))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(DictionaryDescriptor dictionary) {
        Objects.requireNonNull(dictionary, "dictionary is null");
        if (this.effectivePredicate.isNone()) {
            return false;
        }
        Map effectivePredicateDomains = (Map)this.effectivePredicate.getDomains().orElseThrow(() -> new IllegalStateException("Effective predicate other than none should have domains"));
        Domain effectivePredicateDomain = (Domain)effectivePredicateDomains.get(dictionary.getColumnDescriptor());
        return effectivePredicateDomain == null || TupleDomainParquetPredicate.effectivePredicateMatches(effectivePredicateDomain, dictionary);
    }

    private static boolean effectivePredicateMatches(Domain effectivePredicateDomain, DictionaryDescriptor dictionary) {
        return effectivePredicateDomain.overlaps(TupleDomainParquetPredicate.getDomain(effectivePredicateDomain.getType(), dictionary));
    }

    @VisibleForTesting
    public static Domain getDomain(Type type, long rowCount, Statistics<?> statistics, ParquetDataSourceId id, String column, DateTimeZone timeZone) throws ParquetCorruptionException {
        BinaryStatistics binaryStatistics;
        boolean hasNullValue;
        if (statistics == null || statistics.isEmpty()) {
            return Domain.all((Type)type);
        }
        if (statistics.getNumNulls() == rowCount) {
            return Domain.onlyNull((Type)type);
        }
        boolean bl = hasNullValue = statistics.getNumNulls() != 0L;
        if (!statistics.hasNonNullValue() || statistics.genericGetMin() == null || statistics.genericGetMax() == null) {
            return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
        }
        if (type.equals(BooleanType.BOOLEAN) && statistics instanceof BooleanStatistics) {
            boolean hasFalseValues;
            BooleanStatistics booleanStatistics = (BooleanStatistics)statistics;
            boolean hasTrueValues = booleanStatistics.getMin() || booleanStatistics.getMax();
            boolean bl2 = hasFalseValues = !booleanStatistics.getMin() || !booleanStatistics.getMax();
            if (hasTrueValues && hasFalseValues) {
                return Domain.all((Type)type);
            }
            if (hasTrueValues) {
                return Domain.create((ValueSet)ValueSet.of((Type)type, (Object)true, (Object[])new Object[0]), (boolean)hasNullValue);
            }
            if (hasFalseValues) {
                return Domain.create((ValueSet)ValueSet.of((Type)type, (Object)false, (Object[])new Object[0]), (boolean)hasNullValue);
            }
            throw new VerifyException("Impossible boolean statistics");
        }
        if ((type.equals(BigintType.BIGINT) || type.equals(TinyintType.TINYINT) || type.equals(SmallintType.SMALLINT) || type.equals(IntegerType.INTEGER)) && (statistics instanceof LongStatistics || statistics instanceof IntStatistics)) {
            Optional<ParquetIntegerStatistics> parquetIntegerStatistics = TupleDomainParquetPredicate.toParquetIntegerStatistics(statistics, id, column);
            if (parquetIntegerStatistics.isEmpty() || PredicateUtils.isStatisticsOverflow(type, parquetIntegerStatistics.get())) {
                return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
            }
            return TupleDomainParquetPredicate.createDomain(type, hasNullValue, parquetIntegerStatistics.get());
        }
        if (type instanceof DecimalType && ((DecimalType)type).getScale() == 0 && (statistics instanceof LongStatistics || statistics instanceof IntStatistics)) {
            Optional<ParquetIntegerStatistics> parquetIntegerStatistics = TupleDomainParquetPredicate.toParquetIntegerStatistics(statistics, id, column);
            if (parquetIntegerStatistics.isEmpty() || PredicateUtils.isStatisticsOverflow(type, parquetIntegerStatistics.get())) {
                return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
            }
            return TupleDomainParquetPredicate.createDomain(type, hasNullValue, parquetIntegerStatistics.get(), statisticsValue -> {
                if (((DecimalType)type).isShort()) {
                    return statisticsValue;
                }
                return Decimals.encodeScaledValue((BigDecimal)BigDecimal.valueOf(statisticsValue), (int)0);
            });
        }
        if (type.equals(RealType.REAL) && statistics instanceof FloatStatistics) {
            FloatStatistics floatStatistics = (FloatStatistics)statistics;
            if (floatStatistics.genericGetMin().floatValue() > floatStatistics.genericGetMax().floatValue()) {
                throw TupleDomainParquetPredicate.corruptionException(column, id, floatStatistics);
            }
            if (floatStatistics.genericGetMin().isNaN() || floatStatistics.genericGetMax().isNaN()) {
                return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
            }
            ParquetIntegerStatistics parquetStatistics = new ParquetIntegerStatistics(Long.valueOf(Float.floatToRawIntBits(floatStatistics.getMin())), Long.valueOf(Float.floatToRawIntBits(floatStatistics.getMax())));
            return TupleDomainParquetPredicate.createDomain(type, hasNullValue, parquetStatistics);
        }
        if (type.equals(DoubleType.DOUBLE) && statistics instanceof DoubleStatistics) {
            DoubleStatistics doubleStatistics = (DoubleStatistics)statistics;
            if (doubleStatistics.genericGetMin() > doubleStatistics.genericGetMax()) {
                throw TupleDomainParquetPredicate.corruptionException(column, id, doubleStatistics);
            }
            if (doubleStatistics.genericGetMin().isNaN() || doubleStatistics.genericGetMax().isNaN()) {
                return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
            }
            ParquetDoubleStatistics parquetDoubleStatistics = new ParquetDoubleStatistics(doubleStatistics.genericGetMin(), doubleStatistics.genericGetMax());
            return TupleDomainParquetPredicate.createDomain(type, hasNullValue, parquetDoubleStatistics);
        }
        if (type instanceof VarcharType && statistics instanceof BinaryStatistics) {
            Slice maxSlice;
            BinaryStatistics binaryStatistics2 = (BinaryStatistics)statistics;
            Slice minSlice = Slices.wrappedBuffer((byte[])binaryStatistics2.genericGetMin().getBytes());
            if (minSlice.compareTo(maxSlice = Slices.wrappedBuffer((byte[])binaryStatistics2.genericGetMax().getBytes())) > 0) {
                throw TupleDomainParquetPredicate.corruptionException(column, id, binaryStatistics2);
            }
            ParquetStringStatistics parquetStringStatistics = new ParquetStringStatistics(minSlice, maxSlice);
            return TupleDomainParquetPredicate.createDomain(type, hasNullValue, parquetStringStatistics);
        }
        if (type.equals(DateType.DATE) && statistics instanceof IntStatistics) {
            IntStatistics intStatistics = (IntStatistics)statistics;
            if (intStatistics.genericGetMin() > intStatistics.genericGetMax()) {
                throw TupleDomainParquetPredicate.corruptionException(column, id, intStatistics);
            }
            ParquetIntegerStatistics parquetIntegerStatistics = new ParquetIntegerStatistics(Long.valueOf(intStatistics.getMin()), Long.valueOf(intStatistics.getMax()));
            return TupleDomainParquetPredicate.createDomain(type, hasNullValue, parquetIntegerStatistics);
        }
        if (type instanceof TimestampType && statistics instanceof BinaryStatistics && (binaryStatistics = (BinaryStatistics)statistics).genericGetMin().equals((Object)binaryStatistics.genericGetMax())) {
            return Domain.create((ValueSet)ValueSet.of((Type)type, (Object)TrinoTimestampEncoderFactory.createTimestampEncoder((TimestampType)((TimestampType)type), (DateTimeZone)timeZone).getTimestamp(ParquetTimestampUtils.decode(binaryStatistics.genericGetMax())), (Object[])new Object[0]), (boolean)hasNullValue);
        }
        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
    }

    private static Optional<ParquetIntegerStatistics> toParquetIntegerStatistics(Statistics<?> statistics, ParquetDataSourceId id, String column) throws ParquetCorruptionException {
        if (statistics instanceof LongStatistics) {
            LongStatistics longStatistics = (LongStatistics)statistics;
            if (longStatistics.genericGetMin() > longStatistics.genericGetMax()) {
                throw TupleDomainParquetPredicate.corruptionException(column, id, longStatistics);
            }
            return Optional.of(new ParquetIntegerStatistics(longStatistics.genericGetMin(), longStatistics.genericGetMax()));
        }
        if (statistics instanceof IntStatistics) {
            IntStatistics intStatistics = (IntStatistics)statistics;
            if (intStatistics.genericGetMin() > intStatistics.genericGetMax()) {
                throw TupleDomainParquetPredicate.corruptionException(column, id, intStatistics);
            }
            return Optional.of(new ParquetIntegerStatistics(Long.valueOf(intStatistics.getMin()), Long.valueOf(intStatistics.getMax())));
        }
        throw new IllegalArgumentException("Cannot convert statistics of type " + statistics.getClass().getName());
    }

    @VisibleForTesting
    public static Domain getDomain(Type type, DictionaryDescriptor dictionaryDescriptor) {
        Dictionary dictionary;
        if (dictionaryDescriptor == null) {
            return Domain.all((Type)type);
        }
        ColumnDescriptor columnDescriptor = dictionaryDescriptor.getColumnDescriptor();
        Optional<DictionaryPage> dictionaryPage = dictionaryDescriptor.getDictionaryPage();
        if (dictionaryPage.isEmpty()) {
            return Domain.all((Type)type);
        }
        try {
            dictionary = dictionaryPage.get().getEncoding().initDictionary(columnDescriptor, dictionaryPage.get());
        }
        catch (Exception e) {
            return Domain.all((Type)type);
        }
        int dictionarySize = dictionaryPage.get().getDictionarySize();
        if (type.equals(BigintType.BIGINT) && columnDescriptor.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT64) {
            ArrayList<Domain> domains = new ArrayList<Domain>();
            for (int i = 0; i < dictionarySize; ++i) {
                domains.add(Domain.singleValue((Type)type, (Object)dictionary.decodeToLong(i)));
            }
            domains.add(Domain.onlyNull((Type)type));
            return Domain.union(domains);
        }
        if ((type.equals(BigintType.BIGINT) || type.equals(DateType.DATE)) && columnDescriptor.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32) {
            ArrayList<Domain> domains = new ArrayList<Domain>();
            for (int i = 0; i < dictionarySize; ++i) {
                domains.add(Domain.singleValue((Type)type, (Object)dictionary.decodeToInt(i)));
            }
            domains.add(Domain.onlyNull((Type)type));
            return Domain.union(domains);
        }
        if (type.equals(DoubleType.DOUBLE) && columnDescriptor.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.DOUBLE) {
            ArrayList<Domain> domains = new ArrayList<Domain>();
            for (int i = 0; i < dictionarySize; ++i) {
                double value = dictionary.decodeToDouble(i);
                if (Double.isNaN(value)) {
                    return Domain.all((Type)type);
                }
                domains.add(Domain.singleValue((Type)type, (Object)value));
            }
            domains.add(Domain.onlyNull((Type)type));
            return Domain.union(domains);
        }
        if (type.equals(DoubleType.DOUBLE) && columnDescriptor.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.FLOAT) {
            ArrayList<Domain> domains = new ArrayList<Domain>();
            for (int i = 0; i < dictionarySize; ++i) {
                float value = dictionary.decodeToFloat(i);
                if (Float.isNaN(value)) {
                    return Domain.all((Type)type);
                }
                domains.add(Domain.singleValue((Type)type, (Object)value));
            }
            domains.add(Domain.onlyNull((Type)type));
            return Domain.union(domains);
        }
        if (type instanceof VarcharType && columnDescriptor.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.BINARY) {
            ArrayList<Domain> domains = new ArrayList<Domain>();
            for (int i = 0; i < dictionarySize; ++i) {
                domains.add(Domain.singleValue((Type)type, (Object)Slices.wrappedBuffer((byte[])dictionary.decodeToBinary(i).getBytes())));
            }
            domains.add(Domain.onlyNull((Type)type));
            return Domain.union(domains);
        }
        return Domain.all((Type)type);
    }

    private static ParquetCorruptionException corruptionException(String column, ParquetDataSourceId id, Statistics<?> statistics) {
        return new ParquetCorruptionException(String.format("Corrupted statistics for column \"%s\" in Parquet file \"%s\": [%s]", column, id, statistics));
    }

    public static <T extends Comparable<T>> Domain createDomain(Type type, boolean hasNullValue, ParquetRangeStatistics<T> rangeStatistics) {
        return TupleDomainParquetPredicate.createDomain(type, hasNullValue, rangeStatistics, value -> value);
    }

    private static <F, T> Domain createDomain(Type type, boolean hasNullValue, ParquetRangeStatistics<F> rangeStatistics, Function<F, T> function) {
        F min = rangeStatistics.getMin();
        F max = rangeStatistics.getMax();
        if (min != null && max != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)type, function.apply(min), (boolean)true, function.apply(max), (boolean)true), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        if (max != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)type, function.apply(max)), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        if (min != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, function.apply(min)), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
    }
}

