/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.RichColumnDescriptor;
import io.trino.parquet.reader.PrimitiveColumnReader;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DecimalConversions;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import java.util.Objects;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.schema.PrimitiveType;

public class ShortDecimalColumnReader
extends PrimitiveColumnReader {
    private final DecimalType parquetDecimalType;

    ShortDecimalColumnReader(RichColumnDescriptor descriptor, DecimalType parquetDecimalType) {
        super(descriptor);
        this.parquetDecimalType = Objects.requireNonNull(parquetDecimalType, "parquetDecimalType is null");
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type trinoType) {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            if (!(trinoType instanceof DecimalType) && !this.isIntegerType(trinoType)) {
                throw new ParquetDecodingException(String.format("Unsupported Trino column type (%s) for Parquet column (%s)", new Object[]{trinoType, this.columnDescriptor}));
            }
            long value = this.columnDescriptor.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32 ? (long)this.valuesReader.readInteger() : (this.columnDescriptor.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT64 ? this.valuesReader.readLong() : ParquetTypeUtils.getShortDecimalValue(this.valuesReader.readBytes().getBytes()));
            if (trinoType instanceof DecimalType) {
                DecimalType trinoDecimalType = (DecimalType)trinoType;
                if (Decimals.isShortDecimal((Type)trinoDecimalType)) {
                    long rescale = Decimals.longTenToNth((int)Math.abs(trinoDecimalType.getScale() - this.parquetDecimalType.getScale()));
                    long convertedValue = DecimalConversions.shortToShortCast((long)value, (long)this.parquetDecimalType.getPrecision(), (long)this.parquetDecimalType.getScale(), (long)trinoDecimalType.getPrecision(), (long)trinoDecimalType.getScale(), (long)rescale, (long)(rescale / 2L));
                    trinoType.writeLong(blockBuilder, convertedValue);
                } else if (Decimals.isLongDecimal((Type)trinoDecimalType)) {
                    trinoType.writeSlice(blockBuilder, DecimalConversions.shortToLongCast((long)value, (long)this.parquetDecimalType.getPrecision(), (long)this.parquetDecimalType.getScale(), (long)trinoDecimalType.getPrecision(), (long)trinoDecimalType.getScale()));
                }
            } else {
                if (this.parquetDecimalType.getScale() != 0) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Trino column type (%s) for Parquet column (%s)", new Object[]{trinoType, this.columnDescriptor}));
                }
                if (!this.isInValidNumberRange(trinoType, value)) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Could not coerce from %s to %s: %s", this.parquetDecimalType, trinoType, value));
                }
                trinoType.writeLong(blockBuilder, value);
            }
        } else if (this.isValueNull()) {
            blockBuilder.appendNull();
        }
    }

    protected boolean isIntegerType(Type type) {
        return type.equals(TinyintType.TINYINT) || type.equals(SmallintType.SMALLINT) || type.equals(IntegerType.INTEGER) || type.equals(BigintType.BIGINT);
    }

    protected boolean isInValidNumberRange(Type type, long value) {
        if (type.equals(TinyintType.TINYINT)) {
            return -128L <= value && value <= 127L;
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return -32768L <= value && value <= 32767L;
        }
        if (type.equals(IntegerType.INTEGER)) {
            return Integer.MIN_VALUE <= value && value <= Integer.MAX_VALUE;
        }
        if (type.equals(BigintType.BIGINT)) {
            return true;
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    @Override
    protected void skipValue() {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            if (this.columnDescriptor.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32) {
                this.valuesReader.readInteger();
            } else if (this.columnDescriptor.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT64) {
                this.valuesReader.readLong();
            } else {
                this.valuesReader.readBytes();
            }
        }
    }
}

