/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.parquet.bytes.BytesInput;

public interface ParquetDataOutput {
    public static ParquetDataOutput createDataOutput(final Slice slice) {
        Objects.requireNonNull(slice, "slice is null");
        return new ParquetDataOutput(){

            @Override
            public long size() {
                return slice.length();
            }

            @Override
            public void writeData(SliceOutput sliceOutput) {
                sliceOutput.writeBytes(slice);
            }
        };
    }

    public static ParquetDataOutput createDataOutput(final BytesInput bytesInput) {
        Objects.requireNonNull(bytesInput, "slice is null");
        return new ParquetDataOutput(){

            @Override
            public long size() {
                return bytesInput.size();
            }

            @Override
            public void writeData(SliceOutput sliceOutput) {
                try {
                    bytesInput.writeAllTo((OutputStream)sliceOutput);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public long size();

    public void writeData(SliceOutput var1);
}

