/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.presto.rel2presto;

import com.linkedin.coral.com.google.common.collect.ImmutableList;
import com.linkedin.coral.com.google.common.collect.ImmutableMultimap;
import com.linkedin.coral.com.google.common.collect.Multimap;
import com.linkedin.coral.hive.hive2rel.functions.GenericProjectFunction;
import com.linkedin.coral.presto.rel2presto.CalcitePrestoUDFMap;
import com.linkedin.coral.presto.rel2presto.PrestoTryCastFunction;
import com.linkedin.coral.presto.rel2presto.UDFTransformer;
import com.linkedin.coral.presto.rel2presto.functions.GenericProjectToPrestoConverter;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalExchange;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalMatch;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeFamily;

public class Calcite2PrestoUDFConverter {
    private Calcite2PrestoUDFConverter() {
    }

    public static RelNode convertRel(RelNode calciteNode) {
        RelShuttleImpl converter = new RelShuttleImpl(){

            public RelNode visit(LogicalProject project) {
                return super.visit(project).accept((RexShuttle)this.getPrestoRexConverter((RelNode)project));
            }

            public RelNode visit(LogicalFilter inputFilter) {
                return super.visit(inputFilter).accept((RexShuttle)this.getPrestoRexConverter((RelNode)inputFilter));
            }

            public RelNode visit(LogicalAggregate aggregate) {
                return super.visit(aggregate).accept((RexShuttle)this.getPrestoRexConverter((RelNode)aggregate));
            }

            public RelNode visit(LogicalMatch match) {
                return super.visit(match).accept((RexShuttle)this.getPrestoRexConverter((RelNode)match));
            }

            public RelNode visit(TableScan scan) {
                return super.visit(scan).accept((RexShuttle)this.getPrestoRexConverter((RelNode)scan));
            }

            public RelNode visit(TableFunctionScan scan) {
                return super.visit(scan).accept((RexShuttle)this.getPrestoRexConverter((RelNode)scan));
            }

            public RelNode visit(LogicalValues values) {
                return super.visit(values).accept((RexShuttle)this.getPrestoRexConverter((RelNode)values));
            }

            public RelNode visit(LogicalJoin join) {
                return super.visit(join).accept((RexShuttle)this.getPrestoRexConverter((RelNode)join));
            }

            public RelNode visit(LogicalCorrelate correlate) {
                return super.visit(correlate).accept((RexShuttle)this.getPrestoRexConverter((RelNode)correlate));
            }

            public RelNode visit(LogicalUnion union) {
                return super.visit(union).accept((RexShuttle)this.getPrestoRexConverter((RelNode)union));
            }

            public RelNode visit(LogicalIntersect intersect) {
                return super.visit(intersect).accept((RexShuttle)this.getPrestoRexConverter((RelNode)intersect));
            }

            public RelNode visit(LogicalMinus minus) {
                return super.visit(minus).accept((RexShuttle)this.getPrestoRexConverter((RelNode)minus));
            }

            public RelNode visit(LogicalSort sort) {
                return super.visit(sort).accept((RexShuttle)this.getPrestoRexConverter((RelNode)sort));
            }

            public RelNode visit(LogicalExchange exchange) {
                return super.visit(exchange).accept((RexShuttle)this.getPrestoRexConverter((RelNode)exchange));
            }

            public RelNode visit(RelNode other) {
                return super.visit(other).accept((RexShuttle)this.getPrestoRexConverter(other));
            }

            private PrestoRexConverter getPrestoRexConverter(RelNode node) {
                return new PrestoRexConverter(node.getCluster().getRexBuilder());
            }
        };
        return calciteNode.accept((RelShuttle)converter);
    }

    public static class PrestoRexConverter
    extends RexShuttle {
        private final RexBuilder rexBuilder;
        private static final Multimap<SqlTypeFamily, SqlTypeFamily> SUPPORTED_TYPE_CAST_MAP = ImmutableMultimap.builder().putAll((Object)SqlTypeFamily.CHARACTER, (Object[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC, SqlTypeFamily.BOOLEAN}).build();

        public PrestoRexConverter(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public RexNode visitCall(RexCall call) {
            if (call.getOperator() instanceof GenericProjectFunction) {
                return GenericProjectToPrestoConverter.convertGenericProject(this.rexBuilder, call);
            }
            UDFTransformer transformer = CalcitePrestoUDFMap.getUDFTransformer(call.getOperator().getName(), call.operands.size());
            if (transformer != null) {
                return super.visitCall((RexCall)transformer.transformCall(this.rexBuilder, call.getOperands()));
            }
            RexCall modifiedCall = this.adjustInconsistentTypesToEqualityOperator(call);
            return super.visitCall(modifiedCall);
        }

        private RexCall adjustInconsistentTypesToEqualityOperator(RexCall call) {
            SqlOperator op = call.getOperator();
            if (op.getKind() != SqlKind.EQUALS) {
                return call;
            }
            RexNode leftOperand = (RexNode)call.getOperands().get(0);
            RexNode rightOperand = (RexNode)call.getOperands().get(1);
            if (leftOperand.getKind() == SqlKind.CAST) {
                leftOperand = (RexNode)((RexCall)leftOperand).getOperands().get(0);
            }
            if (SUPPORTED_TYPE_CAST_MAP.containsEntry((Object)leftOperand.getType().getSqlTypeName().getFamily(), (Object)rightOperand.getType().getSqlTypeName().getFamily())) {
                RexNode tryCastNode = this.rexBuilder.makeCall(rightOperand.getType(), (SqlOperator)PrestoTryCastFunction.INSTANCE, (List)ImmutableList.of((Object)leftOperand));
                return (RexCall)this.rexBuilder.makeCall(op, new RexNode[]{tryCastNode, rightOperand});
            }
            return call;
        }
    }
}

