/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.presto.rel2presto;

import com.google.common.base.Preconditions;
import com.linkedin.coral.hive.hive2rel.HiveMetastoreClient;
import com.linkedin.coral.hive.hive2rel.HiveToRelConverter;
import com.linkedin.coral.presto.rel2presto.RelToPrestoConverter;
import org.apache.calcite.rel.RelNode;

public class HiveToPrestoConverter {
    private final HiveToRelConverter hiveToRelConverter;
    private final RelToPrestoConverter relToPrestoConverter;

    public static HiveToPrestoConverter create(HiveMetastoreClient mscClient) {
        Preconditions.checkNotNull((Object)mscClient);
        HiveToRelConverter hiveToRelConverter = HiveToRelConverter.create((HiveMetastoreClient)mscClient);
        RelToPrestoConverter relToPrestoConverter = new RelToPrestoConverter();
        return new HiveToPrestoConverter(hiveToRelConverter, relToPrestoConverter);
    }

    private HiveToPrestoConverter(HiveToRelConverter hiveToRelConverter, RelToPrestoConverter relToPrestoConverter) {
        this.hiveToRelConverter = hiveToRelConverter;
        this.relToPrestoConverter = relToPrestoConverter;
    }

    public String toPrestoSql(String hiveSql) {
        RelNode rel = this.hiveToRelConverter.convertSql(hiveSql);
        return this.relToPrestoConverter.convert(rel);
    }

    public String toPrestoSql(String dbName, String viewName) {
        RelNode rel = this.hiveToRelConverter.convertView(dbName, viewName);
        return this.relToPrestoConverter.convert(rel);
    }
}

