/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.presto.rel2presto;

import org.apache.calcite.config.NullCollation;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;

public class PrestoSqlDialect
extends SqlDialect {
    private static final String IDENTIFIER_QUOTE_STRING = "\"";
    public static final PrestoSqlDialect INSTANCE = new PrestoSqlDialect(PrestoSqlDialect.emptyContext().withDatabaseProduct(SqlDialect.DatabaseProduct.UNKNOWN).withDatabaseProductName("Presto").withIdentifierQuoteString("\"").withNullCollation(NullCollation.LAST));

    private PrestoSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    public boolean supportsCharSet() {
        return false;
    }

    public void unparseOffsetFetch(SqlWriter writer, SqlNode offset, SqlNode fetch) {
        this.unparseFetchUsingLimit(writer, offset, fetch);
    }

    public String quoteIdentifier(String name) {
        if (name.contains(IDENTIFIER_QUOTE_STRING)) {
            return name;
        }
        return IDENTIFIER_QUOTE_STRING + name + IDENTIFIER_QUOTE_STRING;
    }

    public void unparseIdentifier(SqlWriter writer, SqlIdentifier identifier) {
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.IDENTIFIER);
        for (int i = 0; i < identifier.names.size(); ++i) {
            writer.sep(".");
            String name = (String)identifier.names.get(i);
            SqlParserPos pos = identifier.getComponentParserPosition(i);
            if (name.equals("")) {
                writer.print("*");
                continue;
            }
            writer.identifier(name, pos.isQuoted());
        }
        writer.endList(frame);
    }

    public boolean requireCastOnString() {
        return true;
    }
}

