/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.presto.rel2presto;

import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlArrayTypeSpec;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlMapTypeSpec;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlRowTypeSpec;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlShuttle;

public class PrestoSqlRewriter
extends SqlShuttle {
    private static SqlDataTypeSpec convertTypeSpec(SqlDataTypeSpec type) {
        if (type instanceof SqlArrayTypeSpec) {
            SqlArrayTypeSpec arrayType = (SqlArrayTypeSpec)type;
            return new SqlArrayTypeSpec(PrestoSqlRewriter.convertTypeSpec(arrayType.getElementTypeSpec()), arrayType.getParserPosition());
        }
        if (type instanceof SqlMapTypeSpec) {
            SqlMapTypeSpec mapType = (SqlMapTypeSpec)type;
            return new SqlMapTypeSpec(PrestoSqlRewriter.convertTypeSpec(mapType.getKeyTypeSpec()), PrestoSqlRewriter.convertTypeSpec(mapType.getValueTypeSpec()), mapType.getParserPosition());
        }
        if (type instanceof SqlRowTypeSpec) {
            SqlRowTypeSpec rowType = (SqlRowTypeSpec)type;
            return new SqlRowTypeSpec(rowType.getFieldNames(), rowType.getFieldTypeSpecs().stream().map(PrestoSqlRewriter::convertTypeSpec).collect(Collectors.toList()), rowType.getParserPosition());
        }
        assert (type.getTypeNameSpec() instanceof SqlBasicTypeNameSpec);
        SqlBasicTypeNameSpec typeNameSpec = (SqlBasicTypeNameSpec)type.getTypeNameSpec();
        int precision = typeNameSpec.getPrecision();
        int scale = typeNameSpec.getScale();
        String charSetName = typeNameSpec.getCharSetName();
        TimeZone timeZone = type.getTimeZone();
        SqlParserPos parserPos = type.getParserPosition();
        switch (typeNameSpec.getTypeName().toString()) {
            case "BINARY": 
            case "VARBINARY": {
                SqlBasicTypeNameSpec binaryTypeName = new SqlBasicTypeNameSpec(SqlTypeName.VARBINARY, -1, -1, charSetName, parserPos);
                return new SqlDataTypeSpec((SqlTypeNameSpec)binaryTypeName, timeZone, parserPos);
            }
            case "FLOAT": {
                SqlBasicTypeNameSpec realTypeName = new SqlBasicTypeNameSpec(SqlTypeName.REAL, precision, scale, charSetName, parserPos);
                return new SqlDataTypeSpec((SqlTypeNameSpec)realTypeName, timeZone, parserPos);
            }
        }
        return type;
    }

    public SqlNode visit(SqlDataTypeSpec type) {
        return PrestoSqlRewriter.convertTypeSpec(type);
    }
}

