/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.presto.rel2presto;

import com.linkedin.coral.com.google.common.collect.ImmutableList;
import com.linkedin.coral.presto.rel2presto.UDFTransformer;
import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;

public class UDFMapUtils {
    private UDFMapUtils() {
    }

    static void createUDFMapEntry(Map<String, UDFTransformer> udfMap, SqlOperator calciteOp, int numOperands, String prestoUDFName) {
        UDFMapUtils.createUDFMapEntry(udfMap, calciteOp, numOperands, prestoUDFName, null, null);
    }

    static void createUDFMapEntry(Map<String, UDFTransformer> udfMap, SqlOperator calciteOp, int numOperands, SqlOperator prestoSqlOperator, String operandTransformer, String resultTransformer) {
        udfMap.put(UDFMapUtils.getKey(calciteOp.getName(), numOperands), UDFTransformer.of(calciteOp.getName(), prestoSqlOperator, operandTransformer, resultTransformer, null));
    }

    static void createUDFMapEntry(Map<String, UDFTransformer> udfMap, SqlOperator calciteOp, int numOperands, SqlOperator prestoSqlOperator) {
        UDFMapUtils.createUDFMapEntry(udfMap, calciteOp, numOperands, prestoSqlOperator, null, null);
    }

    static void createUDFMapEntry(Map<String, UDFTransformer> udfMap, SqlOperator calciteOp, int numOperands, String prestoUDFName, String operandTransformer, String resultTransformer) {
        UDFMapUtils.createUDFMapEntry(udfMap, calciteOp, numOperands, UDFMapUtils.createUDF(prestoUDFName, calciteOp.getReturnTypeInference()), operandTransformer, resultTransformer);
    }

    static void createRuntimeUDFMapEntry(Map<String, UDFTransformer> udfMap, SqlOperator calciteOp, int numOperands, String operatorTransformers, String operandTransformer, String resultTransformer) {
        UDFMapUtils.createUDFMapEntry(udfMap, calciteOp, numOperands, UDFMapUtils.createUDF("", calciteOp.getReturnTypeInference()), operandTransformer, resultTransformer);
    }

    public static SqlOperator createUDF(String udfName, SqlReturnTypeInference typeInference) {
        return new SqlUserDefinedFunction(new SqlIdentifier((List)ImmutableList.of((Object)udfName), SqlParserPos.ZERO), typeInference, null, null, null, null);
    }

    static String getKey(String calciteOpName, int numOperands) {
        return calciteOpName + "_" + numOperands;
    }
}

