/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.presto.rel2presto.functions;

import com.linkedin.coral.presto.rel2presto.functions.PrestoArrayTransformFunction;
import com.linkedin.coral.presto.rel2presto.functions.PrestoMapTransformValuesFunction;
import com.linkedin.coral.presto.rel2presto.functions.PrestoStructCastRowFunction;
import com.linkedin.coral.presto.rel2presto.functions.RelDataTypeToPrestoTypeStringConverter;
import java.util.ArrayList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.MapSqlType;

public class GenericProjectToPrestoConverter {
    private GenericProjectToPrestoConverter() {
    }

    public static RexCall convertGenericProject(RexBuilder builder, RexCall call) {
        RexInputRef transformColumn = (RexInputRef)call.getOperands().get(0);
        RexLiteral columnNameLiteral = (RexLiteral)call.getOperands().get(1);
        String transformColumnFieldName = RexLiteral.stringValue((RexNode)columnNameLiteral);
        RelDataType fromDataType = transformColumn.getType();
        RelDataType toDataType = call.getOperator().inferReturnType(null);
        switch (toDataType.getSqlTypeName()) {
            case ROW: {
                String structDataTypeArgumentString = GenericProjectToPrestoConverter.structDataTypeArgumentString((RelRecordType)fromDataType, (RelRecordType)toDataType, transformColumnFieldName);
                PrestoStructCastRowFunction structFunction = new PrestoStructCastRowFunction(toDataType);
                return (RexCall)builder.makeCall((SqlOperator)structFunction, new RexNode[]{builder.makeLiteral(structDataTypeArgumentString)});
            }
            case ARRAY: {
                String arrayDataTypeArgumentString = GenericProjectToPrestoConverter.arrayDataTypeArgumentString((ArraySqlType)fromDataType, (ArraySqlType)toDataType, transformColumnFieldName);
                PrestoArrayTransformFunction arrayFunction = new PrestoArrayTransformFunction(toDataType);
                return (RexCall)builder.makeCall((SqlOperator)arrayFunction, new RexNode[]{builder.makeLiteral(arrayDataTypeArgumentString)});
            }
            case MAP: {
                String mapDataTypeArgumentString = GenericProjectToPrestoConverter.mapDataTypeArgumentString((MapSqlType)fromDataType, (MapSqlType)toDataType, transformColumnFieldName);
                PrestoMapTransformValuesFunction mapFunction = new PrestoMapTransformValuesFunction(toDataType);
                return (RexCall)builder.makeCall((SqlOperator)mapFunction, new RexNode[]{builder.makeLiteral(mapDataTypeArgumentString)});
            }
        }
        return call;
    }

    private static String mapDataTypeString(MapSqlType fromDataType, MapSqlType toDataType, String fieldNameReference) {
        String mapDataTypeArgumentString = GenericProjectToPrestoConverter.mapDataTypeArgumentString(fromDataType, toDataType, fieldNameReference);
        return String.format("transform_values(%s)", mapDataTypeArgumentString);
    }

    private static String mapDataTypeArgumentString(MapSqlType fromDataType, MapSqlType toDataType, String fieldNameReference) {
        String mapKeyFieldReference = "k";
        String mapValueFieldReference = "v";
        String valueTransformedFieldString = GenericProjectToPrestoConverter.relDataTypeFieldAccessString(fromDataType.getValueType(), toDataType.getValueType(), mapValueFieldReference);
        return String.format("%s, (%s, %s) -> %s", fieldNameReference, mapKeyFieldReference, mapValueFieldReference, valueTransformedFieldString);
    }

    private static String arrayDataTypeString(ArraySqlType fromDataType, ArraySqlType toDataType, String fieldNameReference) {
        String arrayDataTypeArgumentString = GenericProjectToPrestoConverter.arrayDataTypeArgumentString(fromDataType, toDataType, fieldNameReference);
        return String.format("transform(%s)", arrayDataTypeArgumentString);
    }

    private static String arrayDataTypeArgumentString(ArraySqlType fromDataType, ArraySqlType toDataType, String fieldNameReference) {
        String elementFieldReference = "x";
        String elementTransformedFieldString = GenericProjectToPrestoConverter.relDataTypeFieldAccessString(fromDataType.getComponentType(), toDataType.getComponentType(), elementFieldReference);
        return String.format("%s, %s -> %s", fieldNameReference, elementFieldReference, elementTransformedFieldString);
    }

    private static String structDataTypeString(RelRecordType fromDataType, RelRecordType toDataType, String fieldNameReference) {
        String structDataTypeArgumentString = GenericProjectToPrestoConverter.structDataTypeArgumentString(fromDataType, toDataType, fieldNameReference);
        return String.format("cast(%s)", structDataTypeArgumentString);
    }

    private static String structDataTypeArgumentString(RelRecordType fromDataType, RelRecordType toDataType, String fieldNameReference) {
        String structFieldsAccessString = GenericProjectToPrestoConverter.buildStructRelDataTypeFieldAccessString(fromDataType, toDataType, fieldNameReference);
        String castToRowTypeString = RelDataTypeToPrestoTypeStringConverter.buildPrestoTypeString((RelDataType)toDataType);
        return String.format("%s as %s", structFieldsAccessString, castToRowTypeString);
    }

    private static String relDataTypeFieldAccessString(RelDataType fromDataType, RelDataType toDataType, String fieldNameReference) {
        if (fromDataType.equals(toDataType)) {
            return fieldNameReference;
        }
        switch (toDataType.getSqlTypeName()) {
            case ROW: {
                return GenericProjectToPrestoConverter.structDataTypeString((RelRecordType)fromDataType, (RelRecordType)toDataType, fieldNameReference);
            }
            case ARRAY: {
                return GenericProjectToPrestoConverter.arrayDataTypeString((ArraySqlType)fromDataType, (ArraySqlType)toDataType, fieldNameReference);
            }
            case MAP: {
                return GenericProjectToPrestoConverter.mapDataTypeString((MapSqlType)fromDataType, (MapSqlType)toDataType, fieldNameReference);
            }
        }
        return fieldNameReference;
    }

    private static String buildStructRelDataTypeFieldAccessString(RelRecordType fromDataType, RelRecordType toDataType, String fieldNameReference) {
        ArrayList<String> structSelectedFieldStrings = new ArrayList<String>();
        for (RelDataTypeField toDataTypeField : toDataType.getFieldList()) {
            RelDataTypeField fromDataTypeField = fromDataType.getField(toDataTypeField.getName(), false, false);
            if (fromDataTypeField == null) {
                throw new RuntimeException(String.format("Field %s was not found in column %s.", toDataTypeField.getName(), fieldNameReference));
            }
            String fromDataTypeFieldName = String.join((CharSequence)".", fieldNameReference, fromDataTypeField.getName());
            structSelectedFieldStrings.add(GenericProjectToPrestoConverter.relDataTypeFieldAccessString(fromDataTypeField.getType(), toDataTypeField.getType(), fromDataTypeFieldName));
        }
        String subFieldsString = String.join((CharSequence)", ", structSelectedFieldStrings);
        return String.format("row(%s)", subFieldsString);
    }
}

