/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.presto.rel2presto.functions;

import java.util.Arrays;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;

public class PrestoElementAtFunction
extends SqlSpecialOperator {
    public static final PrestoElementAtFunction INSTANCE = new PrestoElementAtFunction();
    private static final SqlSingleOperandTypeChecker ARRAY_OR_MAP = OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.MAP}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY})});

    private PrestoElementAtFunction() {
        super("element_at", SqlKind.OTHER_FUNCTION, 100, true, null, null, null);
    }

    public SqlSpecialOperator.ReduceResult reduceExpr(int ordinal, SqlSpecialOperator.TokenSequence list) {
        SqlNode left = list.node(ordinal - 1);
        SqlNode right = list.node(ordinal + 1);
        return new SqlSpecialOperator.ReduceResult((SqlSpecialOperator)this, ordinal - 1, ordinal + 2, (SqlNode)this.createCall(SqlParserPos.sum(Arrays.asList(left.getParserPosition(), right.getParserPosition(), list.pos(ordinal))), new SqlNode[]{left, right}));
    }

    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlUtil.unparseFunctionSyntax((SqlOperator)this, (SqlWriter)writer, (SqlCall)call);
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of((int)2);
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlNode left = callBinding.operand(0);
        SqlNode right = callBinding.operand(1);
        if (!ARRAY_OR_MAP.checkSingleOperandType(callBinding, left, 0, throwOnFailure)) {
            return false;
        }
        SqlSingleOperandTypeChecker checker = this.getChecker(callBinding);
        return checker.checkSingleOperandType(callBinding, right, 0, throwOnFailure);
    }

    private SqlSingleOperandTypeChecker getChecker(SqlCallBinding callBinding) {
        RelDataType operandType = callBinding.getOperandType(0);
        switch (operandType.getSqlTypeName()) {
            case ARRAY: {
                return OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.INTEGER});
            }
            case MAP: {
                return OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{operandType.getKeyType().getSqlTypeName().getFamily()});
            }
            case ANY: 
            case DYNAMIC_STAR: {
                return OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.INTEGER}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.CHARACTER})});
            }
        }
        throw callBinding.newValidationSignatureError();
    }

    public String getAllowedSignatures(String name) {
        return "<ARRAY>[<INTEGER>]\n<MAP>[<VALUE>]";
    }

    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType operandType = opBinding.getOperandType(0);
        switch (operandType.getSqlTypeName()) {
            case ARRAY: {
                return typeFactory.createTypeWithNullability(operandType.getComponentType(), true);
            }
            case MAP: {
                return typeFactory.createTypeWithNullability(operandType.getValueType(), true);
            }
            case ANY: 
            case DYNAMIC_STAR: {
                return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true);
            }
        }
        throw new AssertionError();
    }
}

