/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.presto.rel2presto.functions;

import com.linkedin.coral.presto.rel2presto.functions.PrestoKeywordsConverter;
import java.util.ArrayList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.MapSqlType;

class RelDataTypeToPrestoTypeStringConverter {
    private RelDataTypeToPrestoTypeStringConverter() {
    }

    public static String buildPrestoTypeString(RelDataType relDataType) {
        switch (relDataType.getSqlTypeName()) {
            case ROW: {
                return RelDataTypeToPrestoTypeStringConverter.buildStructDataTypeString((RelRecordType)relDataType);
            }
            case ARRAY: {
                return RelDataTypeToPrestoTypeStringConverter.buildArrayDataTypeString((ArraySqlType)relDataType);
            }
            case MAP: {
                return RelDataTypeToPrestoTypeStringConverter.buildMapDataTypeString((MapSqlType)relDataType);
            }
            case INTEGER: {
                return "integer";
            }
            case SMALLINT: {
                return "smallint";
            }
            case TINYINT: {
                return "tinyint";
            }
            case BIGINT: {
                return "bigint";
            }
            case DOUBLE: {
                return "double";
            }
            case REAL: 
            case FLOAT: {
                return "real";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case CHAR: {
                return "char";
            }
            case VARCHAR: {
                return "varchar";
            }
            case DATE: {
                return "date";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case TIME: {
                return "time";
            }
            case BINARY: 
            case VARBINARY: 
            case OTHER: {
                return "varbinary";
            }
        }
        throw new RuntimeException(String.format("Unhandled RelDataType %s in Converter from RelDataType to Spark DataType", relDataType.getSqlTypeName()));
    }

    private static String buildStructDataTypeString(RelRecordType relRecordType) {
        ArrayList<String> structFieldStrings = new ArrayList<String>();
        for (RelDataTypeField relDataTypeField : relRecordType.getFieldList()) {
            structFieldStrings.add(String.format("%s %s", PrestoKeywordsConverter.quoteReservedKeyword(relDataTypeField.getName()), RelDataTypeToPrestoTypeStringConverter.buildPrestoTypeString(relDataTypeField.getType())));
        }
        String subFieldsString = String.join((CharSequence)", ", structFieldStrings);
        return String.format("row(%s)", subFieldsString);
    }

    private static String buildArrayDataTypeString(ArraySqlType arraySqlType) {
        String elementDataTypeString = RelDataTypeToPrestoTypeStringConverter.buildPrestoTypeString(arraySqlType.getComponentType());
        return String.format("array(%s)", elementDataTypeString);
    }

    private static String buildMapDataTypeString(MapSqlType mapSqlType) {
        String keyDataTypeString = RelDataTypeToPrestoTypeStringConverter.buildPrestoTypeString(mapSqlType.getKeyType());
        String valueDataTypeString = RelDataTypeToPrestoTypeStringConverter.buildPrestoTypeString(mapSqlType.getValueType());
        return String.format("map(%s, %s)", keyDataTypeString, valueDataTypeString);
    }
}

