/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import io.trino.hadoop.SocksSocketFactory;
import io.trino.plugin.hive.ConfigurationInitializer;
import io.trino.plugin.hive.HdfsConfig;
import io.trino.plugin.hive.util.ConfigurationUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.net.DNSToSwitchMapping;

public class HdfsConfigurationInitializer {
    private final HostAndPort socksProxy;
    private final Duration ipcPingInterval;
    private final Duration dfsTimeout;
    private final Duration dfsConnectTimeout;
    private final int dfsConnectMaxRetries;
    private final int dfsKeyProviderCacheTtlMillis;
    private final String domainSocketPath;
    private final Configuration resourcesConfiguration;
    private final int fileSystemMaxCacheSize;
    private final Set<ConfigurationInitializer> configurationInitializers;
    private final boolean wireEncryptionEnabled;
    private final Integer dfsReplication;

    @VisibleForTesting
    public HdfsConfigurationInitializer(HdfsConfig hdfsConfig) {
        this(hdfsConfig, (Set<ConfigurationInitializer>)ImmutableSet.of());
    }

    @Inject
    public HdfsConfigurationInitializer(HdfsConfig config, Set<ConfigurationInitializer> configurationInitializers) {
        Preconditions.checkArgument((config.getDfsTimeout().toMillis() >= 1L ? 1 : 0) != 0, (Object)"dfsTimeout must be at least 1 ms");
        this.socksProxy = config.getSocksProxy();
        this.ipcPingInterval = config.getIpcPingInterval();
        this.dfsTimeout = config.getDfsTimeout();
        this.dfsConnectTimeout = config.getDfsConnectTimeout();
        this.dfsConnectMaxRetries = config.getDfsConnectMaxRetries();
        this.dfsKeyProviderCacheTtlMillis = Math.toIntExact(config.getDfsKeyProviderCacheTtl().toMillis());
        this.domainSocketPath = config.getDomainSocketPath();
        this.resourcesConfiguration = ConfigurationUtils.readConfiguration(config.getResourceConfigFiles());
        this.fileSystemMaxCacheSize = config.getFileSystemMaxCacheSize();
        this.wireEncryptionEnabled = config.isWireEncryptionEnabled();
        this.dfsReplication = config.getDfsReplication();
        this.configurationInitializers = ImmutableSet.copyOf((Collection)Objects.requireNonNull(configurationInitializers, "configurationInitializers is null"));
    }

    public void initializeConfiguration(Configuration config) {
        ConfigurationUtils.copy(this.resourcesConfiguration, config);
        config.setClass("net.topology.node.switch.mapping.impl", NoOpDNSToSwitchMapping.class, DNSToSwitchMapping.class);
        if (this.socksProxy != null) {
            config.setClass("hadoop.rpc.socket.factory.class.default", SocksSocketFactory.class, SocketFactory.class);
            config.set("hadoop.socks.server", this.socksProxy.toString());
        }
        if (this.domainSocketPath != null) {
            config.setStrings("dfs.domain.socket.path", new String[]{this.domainSocketPath});
        }
        if (!config.get("dfs.domain.socket.path", "").trim().isEmpty()) {
            config.setBooleanIfUnset(HdfsClientConfigKeys.Read.ShortCircuit.KEY, true);
        }
        config.setInt("dfs.client.socket-timeout", Math.toIntExact(this.dfsTimeout.toMillis()));
        config.setInt("ipc.ping.interval", Math.toIntExact(this.ipcPingInterval.toMillis()));
        config.setInt("ipc.client.connect.timeout", Math.toIntExact(this.dfsConnectTimeout.toMillis()));
        config.setInt("ipc.client.connect.max.retries", this.dfsConnectMaxRetries);
        config.setInt("dfs.client.key.provider.cache.expiry", this.dfsKeyProviderCacheTtlMillis);
        if (this.wireEncryptionEnabled) {
            config.set("hadoop.rpc.protection", "privacy");
            config.setBoolean("dfs.encrypt.data.transfer", true);
        }
        config.setInt("fs.cache.max-size", this.fileSystemMaxCacheSize);
        if (this.dfsReplication != null) {
            config.setInt("dfs.replication", this.dfsReplication.intValue());
        }
        this.configurationInitializers.forEach(configurationInitializer -> configurationInitializer.initializeConfiguration(config));
    }

    public static class NoOpDNSToSwitchMapping
    implements DNSToSwitchMapping {
        public List<String> resolve(List<String> names) {
            return ImmutableList.of();
        }

        public void reloadCachedMappings() {
        }

        public void reloadCachedMappings(List<String> names) {
        }
    }
}

