/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.HiveBucketFunction;
import io.trino.plugin.hive.HivePartitionHandle;
import io.trino.plugin.hive.HivePartitioningHandle;
import io.trino.plugin.hive.HiveSplit;
import io.trino.plugin.hive.HiveType;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.connector.ConnectorBucketNodeMap;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPartitionHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;

public class HiveNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        HivePartitioningHandle handle = (HivePartitioningHandle)partitioningHandle;
        List<HiveType> hiveTypes = handle.getHiveTypes();
        return new HiveBucketFunction(handle.getBucketingVersion(), bucketCount, hiveTypes);
    }

    public ConnectorBucketNodeMap getBucketNodeMap(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        HivePartitioningHandle handle = (HivePartitioningHandle)partitioningHandle;
        return ConnectorBucketNodeMap.createBucketNodeMap((int)handle.getBucketCount());
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return value -> ((HiveSplit)value).getBucketNumber().orElseThrow(() -> new IllegalArgumentException("Bucket number not set in split"));
    }

    public List<ConnectorPartitionHandle> listPartitionHandles(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        HivePartitioningHandle handle = (HivePartitioningHandle)partitioningHandle;
        int bucketCount = handle.getBucketCount();
        return (List)IntStream.range(0, bucketCount).mapToObj(HivePartitionHandle::new).collect(ImmutableList.toImmutableList());
    }
}

