/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.acid;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.HiveTypeName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;

public final class AcidSchema {
    public static final String ACID_COLUMN_OPERATION = "operation";
    public static final String ACID_COLUMN_ORIGINAL_TRANSACTION = "originalTransaction";
    public static final String ACID_COLUMN_BUCKET = "bucket";
    public static final String ACID_COLUMN_ROW_ID = "rowId";
    public static final String ACID_COLUMN_ROW_STRUCT = "row";
    public static final String ACID_COLUMN_CURRENT_TRANSACTION = "currentTransaction";
    public static final List<String> ACID_COLUMN_NAMES = ImmutableList.of((Object)"operation", (Object)"originalTransaction", (Object)"bucket", (Object)"rowId", (Object)"currentTransaction", (Object)"row");
    public static final List<RowType.Field> ACID_READ_FIELDS = ImmutableList.of((Object)RowType.field((String)"originalTransaction", (Type)BigintType.BIGINT), (Object)RowType.field((String)"rowId", (Type)BigintType.BIGINT), (Object)RowType.field((String)"bucket", (Type)IntegerType.INTEGER));
    public static final RowType ACID_ROW_ID_ROW_TYPE = RowType.from(ACID_READ_FIELDS);

    private AcidSchema() {
    }

    public static Properties createAcidSchema(HiveType rowType) {
        Properties hiveAcidSchema = new Properties();
        hiveAcidSchema.setProperty("columns", String.join((CharSequence)",", ACID_COLUMN_NAMES));
        hiveAcidSchema.setProperty("columns.types", AcidSchema.createAcidColumnHiveTypes(rowType).stream().map(HiveType::getHiveTypeName).map(HiveTypeName::toString).collect(Collectors.joining(":")));
        return hiveAcidSchema;
    }

    public static Type createRowType(List<String> names, List<Type> types) {
        Objects.requireNonNull(names, "names is null");
        Objects.requireNonNull(types, "types is null");
        Preconditions.checkArgument((names.size() == types.size() ? 1 : 0) != 0, (String)"names size %s differs from types size %s", (int)names.size(), (int)types.size());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < names.size(); ++i) {
            builder.add((Object)new RowType.Field(Optional.of(names.get(i)), types.get(i)));
        }
        return RowType.from((List)builder.build());
    }

    public static List<HiveType> createAcidColumnHiveTypes(HiveType rowType) {
        return ImmutableList.of((Object)HiveType.HIVE_INT, (Object)HiveType.HIVE_LONG, (Object)HiveType.HIVE_INT, (Object)HiveType.HIVE_LONG, (Object)HiveType.HIVE_LONG, (Object)rowType);
    }

    public static List<Type> createAcidColumnPrestoTypes(Type rowType) {
        return ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)rowType);
    }
}

