/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.authentication;

import com.google.common.base.Preconditions;
import io.trino.plugin.base.authentication.KerberosTicketUtils;
import io.trino.plugin.hive.authentication.HadoopAuthentication;
import io.trino.plugin.hive.authentication.KerberosHadoopAuthentication;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.UserGroupInformationShim;

public class CachingKerberosHadoopAuthentication
implements HadoopAuthentication {
    private final KerberosHadoopAuthentication delegate;
    @GuardedBy(value="this")
    private UserGroupInformation userGroupInformation;
    @GuardedBy(value="this")
    private long nextRefreshTime;

    public CachingKerberosHadoopAuthentication(KerberosHadoopAuthentication delegate) {
        this.delegate = Objects.requireNonNull(delegate, "hadoopAuthentication is null");
    }

    @Override
    public synchronized UserGroupInformation getUserGroupInformation() {
        if (this.nextRefreshTime < System.currentTimeMillis() || this.userGroupInformation == null) {
            this.userGroupInformation = Objects.requireNonNull(this.delegate.getUserGroupInformation(), "delegate.getUserGroupInformation() is null");
            this.nextRefreshTime = CachingKerberosHadoopAuthentication.calculateNextRefreshTime(this.userGroupInformation);
        }
        return this.userGroupInformation;
    }

    private static long calculateNextRefreshTime(UserGroupInformation userGroupInformation) {
        Subject subject = UserGroupInformationShim.getSubject((UserGroupInformation)userGroupInformation);
        Preconditions.checkArgument((subject != null ? 1 : 0) != 0, (Object)"subject must be present in kerberos based UGI");
        KerberosTicket tgtTicket = KerberosTicketUtils.getTicketGrantingTicket((Subject)subject);
        return KerberosTicketUtils.getRefreshTime((KerberosTicket)tgtTicket);
    }
}

