/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.authentication;

import io.trino.plugin.hive.ForHdfs;
import io.trino.plugin.hive.authentication.GenericExceptionAction;
import io.trino.plugin.hive.authentication.HadoopAuthentication;
import io.trino.plugin.hive.authentication.HdfsAuthentication;
import io.trino.plugin.hive.authentication.UserGroupInformationUtils;
import java.util.Objects;
import javax.inject.Inject;

public class DirectHdfsAuthentication
implements HdfsAuthentication {
    private final HadoopAuthentication hadoopAuthentication;

    @Inject
    public DirectHdfsAuthentication(@ForHdfs HadoopAuthentication hadoopAuthentication) {
        this.hadoopAuthentication = Objects.requireNonNull(hadoopAuthentication);
    }

    @Override
    public <R, E extends Exception> R doAs(String user, GenericExceptionAction<R, E> action) throws E {
        return UserGroupInformationUtils.executeActionInDoAs(this.hadoopAuthentication.getUserGroupInformation(), action);
    }
}

