/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.aws;

import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.TimingInfo;
import io.airlift.units.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public abstract class AbstractSdkMetricsCollector
extends RequestMetricCollector {
    public final void collectMetrics(Request<?> request, Response<?> response) {
        Number httpClientPoolPendingCount;
        Number httpClientPoolLeasedCount;
        Number httpClientPoolAvailableCount;
        Number throttleExceptions;
        Number retryCounts;
        TimingInfo timingInfo = request.getAWSRequestMetrics().getTimingInfo();
        Number requestCounts = timingInfo.getCounter(AWSRequestMetrics.Field.RequestCount.name());
        if (requestCounts != null) {
            this.recordRequestCount(requestCounts.longValue());
        }
        if ((retryCounts = timingInfo.getCounter(AWSRequestMetrics.Field.HttpClientRetryCount.name())) != null) {
            this.recordRetryCount(retryCounts.longValue());
        }
        if ((throttleExceptions = timingInfo.getCounter(AWSRequestMetrics.Field.ThrottleException.name())) != null) {
            this.recordThrottleExceptionCount(throttleExceptions.longValue());
        }
        if ((httpClientPoolAvailableCount = timingInfo.getCounter(AWSRequestMetrics.Field.HttpClientPoolAvailableCount.name())) != null) {
            this.recordHttpClientPoolAvailableCount(httpClientPoolAvailableCount.longValue());
        }
        if ((httpClientPoolLeasedCount = timingInfo.getCounter(AWSRequestMetrics.Field.HttpClientPoolLeasedCount.name())) != null) {
            this.recordHttpClientPoolLeasedCount(httpClientPoolLeasedCount.longValue());
        }
        if ((httpClientPoolPendingCount = timingInfo.getCounter(AWSRequestMetrics.Field.HttpClientPoolPendingCount.name())) != null) {
            this.recordHttpClientPoolPendingCount(httpClientPoolPendingCount.longValue());
        }
        AbstractSdkMetricsCollector.recordSubTimingDurations(timingInfo, AWSRequestMetrics.Field.HttpRequestTime, this::recordHttpRequestTime);
        AbstractSdkMetricsCollector.recordSubTimingDurations(timingInfo, AWSRequestMetrics.Field.ClientExecuteTime, this::recordClientExecutionTime);
        AbstractSdkMetricsCollector.recordSubTimingDurations(timingInfo, AWSRequestMetrics.Field.RetryPauseTime, this::recordRetryPauseTime);
    }

    protected abstract void recordRequestCount(long var1);

    protected abstract void recordRetryCount(long var1);

    protected abstract void recordThrottleExceptionCount(long var1);

    protected abstract void recordHttpRequestTime(Duration var1);

    protected abstract void recordClientExecutionTime(Duration var1);

    protected abstract void recordRetryPauseTime(Duration var1);

    protected abstract void recordHttpClientPoolAvailableCount(long var1);

    protected abstract void recordHttpClientPoolLeasedCount(long var1);

    protected abstract void recordHttpClientPoolPendingCount(long var1);

    private static void recordSubTimingDurations(TimingInfo timingInfo, AWSRequestMetrics.Field field, Consumer<Duration> consumer) {
        List subTimings = timingInfo.getAllSubMeasurements(field.name());
        if (subTimings != null) {
            for (TimingInfo subTiming : subTimings) {
                Double millis = subTiming.getTimeTakenMillisIfKnown();
                if (millis == null) continue;
                consumer.accept(new Duration(millis.doubleValue(), TimeUnit.MILLISECONDS));
            }
        }
    }
}

