/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.json.JsonBinder;
import io.airlift.json.JsonCodecBinder;
import io.trino.plugin.hive.ForRecordingHiveMetastore;
import io.trino.plugin.hive.RecordingMetastoreConfig;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.RecordingHiveMetastore;
import io.trino.plugin.hive.metastore.WriteHiveMetastoreRecordingProcedure;
import io.trino.plugin.hive.metastore.cache.ForCachingHiveMetastore;
import io.trino.plugin.hive.util.BlockJsonSerde;
import io.trino.plugin.hive.util.HiveBlockEncodingSerde;
import io.trino.spi.block.Block;
import io.trino.spi.procedure.Procedure;
import org.weakref.jmx.guice.ExportBinder;

public class RecordingHiveMetastoreModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        if (((RecordingMetastoreConfig)this.buildConfigObject(RecordingMetastoreConfig.class)).getRecordingPath() != null) {
            this.install(new RecordingModule());
        } else {
            this.install(new NoRecordingModule());
        }
    }

    public static class NoRecordingModule
    implements Module {
        public void configure(Binder binder) {
            binder.bind(HiveMetastore.class).annotatedWith(ForCachingHiveMetastore.class).to(Key.get(HiveMetastore.class, ForRecordingHiveMetastore.class)).in(Scopes.SINGLETON);
        }
    }

    public static class RecordingModule
    implements Module {
        public void configure(Binder binder) {
            binder.bind(HiveMetastore.class).annotatedWith(ForCachingHiveMetastore.class).to(RecordingHiveMetastore.class).in(Scopes.SINGLETON);
            binder.bind(RecordingHiveMetastore.class).in(Scopes.SINGLETON);
            binder.bind(HiveBlockEncodingSerde.class).in(Scopes.SINGLETON);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(RecordingHiveMetastore.Recording.class);
            JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(Block.class).to(BlockJsonSerde.Serializer.class);
            JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Block.class).to(BlockJsonSerde.Deserializer.class);
            ExportBinder.newExporter((Binder)binder).export(RecordingHiveMetastore.class).withGeneratedName();
            Multibinder.newSetBinder((Binder)binder, Procedure.class).addBinding().toProvider(WriteHiveMetastoreRecordingProcedure.class).in(Scopes.SINGLETON);
        }
    }
}

