/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.alluxio;

import alluxio.ClientContext;
import alluxio.client.table.RetryHandlingTableMasterClient;
import alluxio.client.table.TableMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.master.MasterClientContext;
import alluxio.util.ConfigurationUtils;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.alluxio.AlluxioHiveMetastore;
import io.trino.plugin.hive.metastore.alluxio.AlluxioHiveMetastoreConfig;
import org.weakref.jmx.guice.ExportBinder;

public class AlluxioMetastoreModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(AlluxioHiveMetastoreConfig.class);
        binder.bind(HiveMetastore.class).to(AlluxioHiveMetastore.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(HiveMetastore.class).as(generator -> generator.generatedNameOf(AlluxioHiveMetastore.class));
    }

    @Provides
    public TableMasterClient provideCatalogMasterClient(AlluxioHiveMetastoreConfig config) {
        return AlluxioMetastoreModule.createCatalogMasterClient(config);
    }

    public static TableMasterClient createCatalogMasterClient(AlluxioHiveMetastoreConfig config) {
        InstancedConfiguration conf = new InstancedConfiguration(ConfigurationUtils.defaults());
        String addr = config.getMasterAddress();
        String[] parts = addr.split(":", 2);
        conf.set(PropertyKey.MASTER_HOSTNAME, (Object)parts[0]);
        if (parts.length > 1) {
            conf.set(PropertyKey.MASTER_RPC_PORT, (Object)parts[1]);
        }
        MasterClientContext context = MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)conf)).build();
        return new RetryHandlingTableMasterClient(context);
    }
}

