/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.file;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import javax.validation.constraints.NotNull;

public class FileHiveMetastoreConfig {
    public static final String VERSION_COMPATIBILITY_CONFIG = "hive.metastore.version-compatibility";
    private String catalogDirectory;
    private VersionCompatibility versionCompatibility = VersionCompatibility.NOT_SUPPORTED;
    private String metastoreUser = "presto";
    private boolean assumeCanonicalPartitionKeys;

    @NotNull
    public String getCatalogDirectory() {
        return this.catalogDirectory;
    }

    @Config(value="hive.metastore.catalog.dir")
    @ConfigDescription(value="Hive file-based metastore catalog directory")
    public FileHiveMetastoreConfig setCatalogDirectory(String catalogDirectory) {
        this.catalogDirectory = catalogDirectory;
        return this;
    }

    @NotNull
    public VersionCompatibility getVersionCompatibility() {
        return this.versionCompatibility;
    }

    @Config(value="hive.metastore.version-compatibility")
    public FileHiveMetastoreConfig setVersionCompatibility(VersionCompatibility versionCompatibility) {
        this.versionCompatibility = versionCompatibility;
        return this;
    }

    @NotNull
    public String getMetastoreUser() {
        return this.metastoreUser;
    }

    @Config(value="hive.metastore.user")
    @ConfigDescription(value="Hive file-based metastore username for file access")
    public FileHiveMetastoreConfig setMetastoreUser(String metastoreUser) {
        this.metastoreUser = metastoreUser;
        return this;
    }

    public boolean isAssumeCanonicalPartitionKeys() {
        return this.assumeCanonicalPartitionKeys;
    }

    @Config(value="hive.metastore.assume-canonical-partition-keys")
    public FileHiveMetastoreConfig setAssumeCanonicalPartitionKeys(boolean assumeCanonicalPartitionKeys) {
        this.assumeCanonicalPartitionKeys = assumeCanonicalPartitionKeys;
        return this;
    }

    public static enum VersionCompatibility {
        NOT_SUPPORTED,
        UNSAFE_ASSUME_COMPATIBILITY;

    }
}

